package com.biz.crm.mdm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 职位与用户关联表实体类
 *
 * @author zxw
 * @date 2020-10-10 13:59:04
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_supply")
public class MdmCustomerSupplyEntity extends CrmExtTenEntity<MdmCustomerSupplyEntity> {

    /**
     * 职位编码
     */
    private String positionCode;

    /**
     * 客户编码
     */
    private String customerCode;


    /**
     * 渠道
     */
    private String channel;

    /**
     * 组织编码
     */
    private String orgCode;

    @ApiModelProperty("销售公司编码")
    private String saleCompany;

}
