package com.biz.crm.mdm.function.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 按钮表实体类
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_button")
public class MdmButtonEntity extends CrmExtTenEntity<MdmButtonEntity> {


    /**
     * 按钮编码
     */
	@CrmColumn(name = "button_code", length = 64)
    private String buttonCode;

    /**
     * 按钮名称
     */
	@CrmColumn(name = "button_name", length = 64)
    private String buttonName;


    @ApiModelProperty("按钮类型:0表头按钮，1行按钮")
	@CrmColumn(name = "button_type", length = 64)
    private String buttonType;

    @ApiModelProperty("图标编码")
	@CrmColumn(name = "icon_code", length = 64)
    private String iconCode;
}
