package com.biz.crm.mdm.function.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 菜单表实体类
 *
 * @author zxw
 * @date 2020-11-18 10:26:31
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_function")
public class MdmFunctionEntity extends CrmExtTenEntity<MdmFunctionEntity> {

    /**
     * 菜单编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 菜单名称
     */
	@CrmColumn(name = "function_name", length = 64)
    private String functionName;

    /**
     * 菜单层级
     */
	@CrmColumn(name = "function_level", length = 64)
    private String functionLevel;

    /**
     * 菜单排序
     */
	@CrmColumn(name = "function_order", length = 64)
    private String functionOrder;

    /**
     * 菜单地址
     */
	@CrmColumn(name = "function_url", length = 200)
    private String functionUrl;

    /**
     * 上级菜单编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

    /**
     * 图标
     */
	@CrmColumn(name = "function_icon", length = 64)
    private String functionIcon;

    /**
     * 所属模块，1：mdm，2：dms，3：tpm，4：sfa
     */
	@CrmColumn(name = "function_module", length = 64)
    private String functionModule;

    /**
     * 0：系统菜单，1：dms商城，2：dms小程序，3:sfa小程序，4：sfaapp
     */
	@CrmColumn(name = "function_config", length = 64)
    private String functionConfig;

    @ApiModelProperty("是否允许页面配置")
	@CrmColumn(name = "page_config", length = 64)
    private String pageConfig;

    @ApiModelProperty("是否允许流程配置 ")
	@CrmColumn(name = "menu_config", length = 64)
    private String menuConfig;

    @ApiModelProperty("图标编码")
	@CrmColumn(name = "icon_code", length = 64)
    private String iconCode;

    @ApiModelProperty("菜单显示模式:1显示0隐藏")
	@CrmColumn(name = "function_visible", length = 64)
    private String functionVisible;

    @ApiModelProperty("关联单据编码")
    @CrmColumn(name = "relation_bill_code", length = 64)
    private String relationBillCode;

}
