package com.biz.crm.mdm.function.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 菜单-角色关联表实体类
 *
 * @author zxw
 * @date 2020-11-18 10:42:36
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_function_role")
public class MdmFunctionRoleEntity extends BaseIdEntity {

    /**
     * 菜单编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 角色编码
     */
	@CrmColumn(name = "role_code", length = 64)
    private String roleCode;

}
