package com.biz.crm.mdm.material.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_material")
public class MdmMaterialEntity extends CrmTreeEntity<MdmMaterialEntity> {


    /**
     * 产品层级编码
     */
    private String productLevelCode;

    /**
     * 物料编码
     */
    private String materialCode;

    /**
     * 产品名称
     */
    private String materialName;


    /**
     * ai编码
     */
    private String aiCode;

    /**
     * 条形码
     */
    private String barCode;

    /**
     * 基本单位
     */
    private String baseUnit;

    /**
     * 物料类型
     */
    private String materialType;

    /**
     * 销售公司
     */
    private String saleCompany;

    /**
     * 销售单位
     */
    private String saleUnit;

    /**
     * 规格
     */
    private String specification;

    /**
     * 单位换算系数
     */
    private String unitConversion;

    /**
     * 成本价格
     */
    private String costPrice;

    /**
     * 毛重
     */
    private String grossWeight;

    /**
     * 净重
     */
    private String netWeight;

    /**
     * 容量
     */
    private String capacity;

}
