package com.biz.crm.mdm.org.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeTenEntity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 组织表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_org")
public class MdmOrgEntity extends CrmTreeTenEntity<MdmOrgEntity> {

    /**
     * 组织编码
     */
    private String orgCode;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 组织类型
     */
    private String orgType;

    /**
     * 组织描述
     */
    private String orgDesc;

    /**
     * 上级组织编码
     */
    private String parentCode;

    /**
     * 对应SAP组织编码
     */
    private String sapOrgCode;

    /**
     * 对应SAP组织编码利润中心编码
     */
    private String sapProfitOrgCode;

    /**
     * 对应SAP组织编码成本中心编码
     */
    private String sapCostOrgCode;

}
