package com.biz.crm.mdm.position.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 职位-用户关联表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_position_user")
public class MdmPositionUserEntity extends BaseIdEntity {

    /**
     * 职位编码
     */
    private String positionCode;

    /**
     * 用户登录名
     */
    private String userName;

    /**
     * 是否主职位 1是 0否
     */
    private String primaryFlag;

    /**
     * 是否当前职位 1是 0否
     */
    private String currentFlag;

}
