package com.biz.crm.mdm.price.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 价格维护主表 实体类
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_price_setting")
public class MdmPriceSettingEntity extends CrmExtEntity<MdmPriceSettingEntity> {

    /**
     * 价格设置编码
     */
    private String priceSettingCode;

    /**
     * 条件类型编码
     */
    private String conditionTypeCode;

    /**
     * 条件字段分类编码
     */
    private String conditionGroupCode;

    /**
     * 企业组织编码
     */
    private String orgCode;

    /**
     * 企业组织名称
     */
    private String orgName;

    /**
     * 渠道编码
     */
    private String channel;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 客户编码
     */
    private String customerCode;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 单位类型 unit_type
     */
    private String unitType;

    /**
     * 币种编码(字典)
     */
    private String currencyType;

    /**
     * 币种名称
     */
    private String currencyTypeName;

    /**
     * 价格单位(字典,选项数据跟选择的商品有关)
     */
    private String priceUnit;

    /**
     * 价格单位名称
     */
    private String priceName;

    /**
     * 有效期开始日期
     */
    private String beginDate;

    /**
     * 有效期开始时间
     */
    private String beginDateSecond;

    /**
     * 有效期结束日期
     */
    private String endDate;

    /**
     * 有效期结束时间
     */
    private String endDateSecond;

    @ApiModelProperty("价格组")
    private String priceGroup;

    @ApiModelProperty("终端编码")
    private String terminalCode;

}
