package com.biz.crm.mdm.product.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 商品主表实体类
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_product")
@Api(tags = "MDM-商品主表实体")
public class MdmProductEntity extends CrmTreeEntity<MdmProductEntity> {

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 产品层级编码
     */
    private String productLevelCode;

    /**
     * 商品类型(数据字典)
     */
    private String productType;

    /**
     * 销售单位
     */
    private String saleUnit;

    /**
     * 规格
     */
    private String spec;

    /**
     * 基本单位
     */
    private String baseUnit;

    /**
     * 开始日期
     */
    private String beginDate;

    /**
     * 开始时间
     */
    private String beginDateSecond;

    /**
     * 结束日期
     */
    private String endDate;
    /**
     * 结束时间
     */
    private String endDateSecond;

    /**
     * 上下架状态(数据字典)
     */
    private String isShelf;

    /**
     * 条形码
     */
    private String barCode;

    @ApiModelProperty("是否维护图片1是0否")
    private String maintenancePicture;

    @ApiModelProperty("是否维护详情1是0否")
    private String maintenanceIntroduction;

    /***主图片url*/
    private String primaryPictureUrl;


}
