package com.biz.crm.mdm.product.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import io.swagger.annotations.Api;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 实体类
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_product_material")
@Api(tags = "MDM-商品与物料关系实体")
public class MdmProductMaterialEntity extends CrmExtTenEntity<MdmProductMaterialEntity> {

    /**
     * 物料数量
     */
    private Integer count;

    /**
     * 物料编码
     */
    private String materialCode;

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 比例
     */
    private BigDecimal ratio;

}
