package com.biz.crm.mdm.terminal.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;





/**
 * @author Liao Hua
 * @date 2020/9/3 11:18 上午
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("mdm_terminal")
//@CrmTable(name = "mdm_terminal",tableNote = "终端信息表")
public class MdmTerminalEntity extends CrmTreeEntity<MdmTerminalEntity> {

    /**
     * 高德地图ID
     */
    @ApiModelProperty("高德地图ID")
    @CrmColumn(name = "amap_id", length = 64)
    private String amapId;

    /**
     * 终端编码
     */
    @ApiModelProperty("终端编码")
    @CrmColumn(name = "terminal_code", length = 64)
    private String terminalCode;
    /**
     * 终端名称
     */
    @ApiModelProperty("终端名称")
    @CrmColumn(name = "terminal_name", length = 64)
    private String terminalName;

    /**
     * 终端类型
     */
    @ApiModelProperty("终端类型")
    @CrmColumn(name = "terminal_type", length = 64)
    private String terminalType;

    /**
     * 所属组织编码
     */
    @ApiModelProperty("所属组织编码")
    @CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 客户组织编码
     */
    @ApiModelProperty("客户组织编码")
    @CrmColumn(name = "customer_org_code", length = 64)
    private String customerOrgCode;

    /**
     * 渠道
     */
    @ApiModelProperty("渠道")
    @CrmColumn(name = "channel", length = 255)
    private String channel;

    /**
     * 营业执照法人姓名
     */
    @ApiModelProperty("营业执照法人姓名")
    @CrmColumn(name = "license_person_name", length = 255)
    private String licensePersonName;

    /**
     * 营业执照注册号
     */
    @ApiModelProperty("营业执照注册号")
    @CrmColumn(name = "license_register_number", length = 255)
    private String licenseRegisterNumber;

    /**
     * 营业执照企业名称
     */
    @ApiModelProperty("营业执照企业名称")
    @CrmColumn(name = "license_firm_name", length = 255)
    private String licenseFirmName;

    /**
     * 终端地址
     */
    @ApiModelProperty("终端地址")
    @CrmColumn(name = "terminal_address", length = 64)
    private String terminalAddress;

    /**
     * 省
     */
    @ApiModelProperty("省编码")
    @CrmColumn(name = "province_code", length = 64)
    private String provinceCode;

    @CrmColumn(name = "province_name", length = 128)
    private String provinceName;

    /**
     * 市
     */
    @ApiModelProperty("市编码")
    @CrmColumn(name = "city_code", length = 64)
    private String cityCode;

    @CrmColumn(name = "city_name", length = 128)
    private String cityName;

    /**
     * 区
     */
    @ApiModelProperty("区编码")
    @CrmColumn(name = "district_code", length = 64)
    private String districtCode;

    @CrmColumn(name = "district_name", length = 128)
    private String districtName;

    /**
     * 店招照片
     */
    @ApiModelProperty("店招照片")
    @CrmColumn(name = "shop_image_path", length = 500)
    private String shopImagePath;

    /**
     * 营业执照照片
     */
    @ApiModelProperty("营业执照照片")
    @CrmColumn(name = "license_image_path", length = 500)
    private String licenseImagePath;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    @CrmColumn(name = "longitude", length = 64)
    private String longitude;

    /**
     * 纬度
     */
    @ApiModelProperty("纬度")
    @CrmColumn(name = "latitude", length = 64)
    private String latitude;

    @ApiModelProperty("客户分类")
    @CrmColumn(name = "customer_classification", length = 64)
    private String customerClassification;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    @CrmColumn(name = "act_approve_status", length = 64)
    private String actApproveStatus;
    @ApiModelProperty("合作状态")
    @CrmColumn(name = "cooperate_status", length = 64)
    private String cooperateStatus;


    @ApiModelProperty("kms关联客户门店id")
    @CrmColumn(name = "store_id", length = 64)
    private String storeId;

    @ApiModelProperty("kms直营体系id")
    @CrmColumn(name = "direct_system_id", length = 64)
    private String directSystemId;

    @ApiModelProperty("kms售达方id")
    @CrmColumn(name = "sell_party_id", length = 64)
    private String sellPartyId;

    /**
     * 审批类型
     */
    @CrmColumn(name = "approval_type", length = 32)
    private String approvalType;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 64)
    private String processCode;

}
