package com.biz.crm.mdm.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 用户信息表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_user")
public class MdmUserEntity extends CrmExtEntity<MdmUserEntity> {

    /**
     * 用户账号登录信息
     */
    private String userName;

    /**
     * 用户编码
     */
    @Deprecated
    private String userCode;

    /**
     * 密码（经过加密的）
     */
    private String userPassword;

    /**
     * 用户类型
     */
    private String userType;

    /**
     * 性别
     */
    private String gender;

    /**
     * 电话
     */
    private String userPhone;

    /**
     * 人员姓名
     */
    private String fullName;

    /**
     * 生效时间
     */
    private String endTime;

    /**
     * 失效时间
     */
    private String startTime;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 锁定状态 003/009
     */
    private String lockState;

    /**
     * 最后一次登录时间
     */
    private String lastLoginTime;

    /**
     * 客户用户冗余客户名称集合（英文逗号间隔）
     */
    private String userHeadUrl;

    /***是否需要强制修改密码 0/1*/
    private String forceChangePassword;

    /***工号*/
    private String jobCode;

    /***员工类型*/
    private String employeeType;

    /***员工状态*/
    private String employeeStatus;

    /***身份证号码*/
    private String identityCardNumber;

    /***身份证地址*/
    private String identityCardAddress;

    /***民族*/
    private String nationality;

    /***现住址*/
    private String currentAddress;

    /***政治面貌*/
    private String politicalAffiliation;

}
