package com.biz.crm.sfa.test.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 线路组管理 实体类
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_group")
@CrmTable(name = "sfa_visit_group", tableNote = "线路组管理")
public class SfaVisitGroupEntity extends CrmExtTenEntity<SfaVisitGroupEntity> {

    /**
     * 线路组编码 线路组编码
     */
    @CrmColumn(name = "group_code", length = 32, note = "线路组编码 线路组编码")
    private String groupCode;

    /**
     * 线路组名称 线路组名称
     */
    @CrmColumn(name = "group_name", length = 100, note = "线路组名称 线路组名称")
    private String groupName;

    /**
     * 人员账号 人员账号
     */
    @CrmColumn(name = "user_name", length = 32, note = "人员账号 人员账号")
    private String userName;

    /**
     * 人员姓名 人员姓名
     */
    @CrmColumn(name = "full_name", length = 100, note = "人员姓名 人员姓名")
    private String fullName;

    /**
     * 职位编码 职位编码
     */
    @CrmColumn(name = "pos_code", length = 32, note = "职位编码 职位编码")
    private String posCode;

    /**
     * 职位名称 职位名称
     */
    @CrmColumn(name = "pos_name", length = 100, note = "职位名称 职位名称")
    private String posName;

    /**
     * 组织编码 组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "组织编码 组织编码")
    private String orgCode;

    /**
     * 组织名称 组织名称
     */
    @CrmColumn(name = "org_name", length = 100, note = "组织名称 组织名称")
    private String orgName;

}
