package com.biz.crm.sfa.test.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 线路组对应客户信息 实体类
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visitclient_rel")
@CrmTable(name = "sfa_visitclient_rel", tableNote = "线路组对应客户信息 ")
public class SfaVisitclientRelEntity extends CrmExtTenEntity<SfaVisitclientRelEntity> {

    /**
     * 客户id 客户id
     */
    @CrmColumn(name = "client_id", length = 32, note = "客户id 客户id")
    private String clientId;

    /**
     * 客户编码 客户编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "客户编码 客户编码")
    private String clientCode;

    /**
     * 客户名称 客户名称
     */
    @CrmColumn(name = "client_name", length = 100, note = "客户名称 客户名称")
    private String clientName;

    /**
     * 客户类型 客户类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "客户类型 客户类型")
    private String clientType;

    @CrmColumn(name = "client_type_name", length = 32, note = "客户类型 客户类型")
    private String clientTypeName;
    /**
     * 网点地址
     */
    @CrmColumn(name = "client_address", length = 200, note = "网点地址")
    private String clientAddress;

    /**
     * 网点联系人
     */
    @CrmColumn(name = "client_contacts", length = 20, note = "网点联系人")
    private String clientContacts;

    /**
     * 网点电话
     */
    @CrmColumn(name = "client_phone", length = 20, note = "网点电话")
    private String clientPhone;

    /**
     * 网点图片
     */
    @CrmColumn(name = "client_photo", length = 200, note = "网点图片")
    private String clientPhoto;

    /**
     * 线路组编码 线路组编码
     */
    @CrmColumn(name = "group_code", length = 32, note = "线路组编码 线路组编码")
    private String groupCode;

    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    private String clientSubclass;

    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

}
