package com.biz.crm.tpm.feebudget.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用预算明细 实体类
 *
 * @author huanglong
 * @date 2020-09-16 10:42:32
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_fee_budget_details")
public class TpmFeeBudgetDetailsEntity extends CrmExtEntity<TpmFeeBudgetDetailsEntity> {

    /**
     * 费用预算编码
     */
    @CrmColumn(name = "fee_budget_code", length = 32,note = "费用预算编码")
    private String feeBudgetCode;

    /**
     * 费用预算类型(字典)
     */
    @CrmColumn(name = "fee_budget_type", length = 32,note = "费用预算类型(字典)")
    private String feeBudgetType;

    /**
     * 组织类型
     */
    @CrmColumn(name = "org_type", length = 32,note = "组织类型")
    private String orgType;

    /**
     * 预算扣减顺序
     */
    @CrmColumn(name = "reduce_order",mysqlType = "int(10)", oracleType = "NUMBER(10,0)",note = "预算扣减顺序")
    private Integer reduceOrder;

    /**
     * 预算扣减比例
     */
    @CrmColumn(name = "reduce_ratio",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "预算扣减比例")
    private BigDecimal reduceRatio;

    /**
     * 业务单据编码
     */
    @CrmColumn(name = "business_code", length = 32,note = "业务单据编码")
    private String businessCode;

    /**
     * 业务单据名称
     */
    @CrmColumn(name = "business_name", length = 200,note = "业务单据名称")
    private String businessName;

    /**
     * 业务单据明细编码
     */
    @CrmColumn(name = "business_line_code", length = 32,note = "业务单据明细编码")
    private String businessLineCode;

    /**
     * 业务备注
     */
    @CrmColumn(name = "business_remarks", length = 200,note = "业务备注")
    private String businessRemarks;

    /**
     * 费用预算明细类型(字典)
     */
    @CrmColumn(name = "fee_budget_detail_type", length = 32,note = "费用预算明细类型(字典)")
    private String feeBudgetDetailType;

    /**
     * 费用预算明细类型名称
     */
    @CrmColumn(name = "fee_budget_detail_type_name", length = 60,note = "费用预算明细类型名称")
    private String feeBudgetDetailTypeName;

    /**
     * 年份(明细产生的年份)
     */
    @CrmColumn(name = "year", length = 32,note = "年份(明细产生的年份)")
    private String year;

    /**
     * 月份(明细产生的月份)
     */
    @CrmColumn(name = "month", length = 32,note = "月份(明细产生的月份)")
    private String month;

    /**
     * 预算科目编码
     */
    @CrmColumn(name = "budget_subjects_code", length = 32,note = "预算科目编码")
    private String budgetSubjectsCode;

    /**
     * 预算科目名称
     */
    @CrmColumn(name = "budget_subjects_name", length = 60,note = "预算科目名称")
    private String budgetSubjectsName;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;

    /**
     * 客户所属组织编码
     */
    @CrmColumn(name = "customer_org_code", length = 32,note = "客户所属组织编码")
    private String customerOrgCode;

    /**
     * 客户所属组织名称
     */
    @CrmColumn(name = "customer_org_name", length = 60,note = "客户所属组织名称")
    private String customerOrgName;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32,note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 60,note = "产品名称")
    private String productName;

    /**
     * 渠道编码
     */
    @CrmColumn(name = "channel", length = 32,note = "渠道编码")
    private String channel;

    /**
     * 渠道名称
     */
    @CrmColumn(name = "channel_name", length = 60,note = "渠道名称")
    private String channelName;

    /**
     * 门店编码
     */
    @CrmColumn(name = "terminal_code", length = 32,note = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmColumn(name = "terminal_name", length = 60,note = "门店名称")
    private String terminalName;

    /**
     * 企业组织编码
     */
    @CrmColumn(name = "org_code", length = 32,note = "企业组织编码")
    private String orgCode;

    /**
     * 企业组织名称
     */
    @CrmColumn(name = "org_name", length = 60,note = "企业组织名称")
    private String orgName;

    /**
     * 期初金额
     */
    @CrmColumn(name = "init_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "期初金额")
    private BigDecimal initAmount;

    /**
     * 金额;当前操作金额
     */
    @CrmColumn(name = "fee_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "金额;当前操作金额")
    private BigDecimal feeAmount;

    /**
     * 操作前余额;当前余额
     */
    @CrmColumn(name = "befor_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "操作前余额;当前余额")
    private BigDecimal beforAmount;

    /**
     * 操作后余额
     */
    @CrmColumn(name = "after_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "操作前余额;操作后余额")
    private BigDecimal afterAmount;

}
