package com.biz.crm.tpm.incomebudget.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 收入预算;实体类
 *
 * @author lf
 * @date 2021-02-02 17:55:15
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_income_budget")
@CrmTable(name = "tpm_income_budget",tableNote = "TPM-收入预算")
public class TpmIncomeBudgetEntity extends CrmExtEntity<TpmIncomeBudgetEntity> {

    /**
     * 预算编码;预算编码
     */
    @CrmColumn(name = "income_code", length = 32,note = "预算编码")
    private String incomeCode;

    /**
     * 预算名称;预算名称
     */
    @CrmColumn(name = "income_name", length = 60,note = "预算名称")
    private String incomeName;

    /**
     * 年;年
     */
    @CrmColumn(name = "budget_year", length = 32,note = "年")
    private String budgetYear;

    /**
     * 月份;月份
     */
    @CrmColumn(name = "budget_month", length = 32,note = "月份")
    private String budgetMonth;

    /**
     * 组织编码;组织编码
     */
    @CrmColumn(name = "org_code", length = 32,note = "组织编码")
    private String orgCode;

    /**
     * 组织;组织
     */
    @CrmColumn(name = "org_name", length = 60,note = "组织")
    private String orgName;

    /**
     * 渠道字典编码
     */
    @CrmColumn(name = "channel", note = "渠道字典编码")
    private String channel;

    /**
     * 渠道名称
     */
    @CrmColumn(name = "channel_name", note = "渠道名称")
    private String channelName;

    /**
     * 产品编码;产品编码
     */
    @CrmColumn(name = "product_code", length = 32,note = "产品编码")
    private String productCode;

    /**
     * 产品;产品
     */
    @CrmColumn(name = "product_name", length = 60,note = "产品")
    private String productName;

    /**
     * 分组编码;分组编码
     */
    @CrmColumn(name = "fee_budget_type", length = 32,note = "分组编码")
    private String feeBudgetType;

    /**
     * 分组;分组
     */
    @CrmColumn(name = "fee_budget_type_name", length = 60,note = "分组名称")
    private String feeBudgetTypeName;

    /**
     * 客户编码;客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;

    /**
     * 客户;客户
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户")
    private String customerName;

    /**
     * 门店编码;门店编码
     */
    @CrmColumn(name = "terminal_code", length = 32,note = "门店编码")
    private String terminalCode;

    /**
     * 门店名称;门店名称
     */
    @CrmColumn(name = "terminal_name", length = 60,note = "门店名称")
    private String terminalName;

    /**
     * 期初金额;期初金额
     */
    @CrmColumn(name = "init_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "期初金额")
    private BigDecimal initAmount;

    /**
     * 当前余额;当前余额
     */
    @CrmColumn(name = "amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "当前余额")
    private BigDecimal amount;

    /**
     * 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 32,note = "产品层级编码")
    private String productLevelCode;

    /**
     * 产品层级名称
     */
    @CrmColumn(name = "product_level_name", length = 60,note = "产品层级名称")
    private String productLevelName;

//    /**
//     * 收入预算类型
//     */
//    @CrmColumn(name = "income_type", length = 32,note = "收入预算类型")
//    private String incomeType;

    /**
     * 客户组织编码
     */
    @CrmColumn(name = "customer_org_code", length = 32,note = "客户组织编码")
    private String customerOrgCode;

    /**
     * 客户组织名称
     */
    @CrmColumn(name = "customer_org_name", length = 60,note = "客户组织名称")
    private String customerOrgName;

}
