package com.biz.crm.websocket.config;

import com.biz.crm.websocket.interceptor.WebSocketInterceptor;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.websocket.config
 * @Description: 首先注入一个ServerEndpointExporterBean,该Bean会自动注册使用@ServerEndpoint注解申明的websocket endpoint
 * @date 2020/12/2 下午3:26
 */
@Configuration
@EnableWebSocket
public class WebSocketConfig implements WebSocketConfigurer {
    @Override
    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {

        registry.addHandler(new UserWebSocketHandler(), "/websocket/user").setAllowedOrigins("*").addInterceptors(new WebSocketInterceptor());
    }
    @Bean
    @Nullable
    public TaskScheduler defaultSockJsTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolScheduler = new ThreadPoolTaskScheduler();
        threadPoolScheduler.setThreadNamePrefix("SockJS-");
        threadPoolScheduler.setPoolSize(10);
        threadPoolScheduler.initialize();
        threadPoolScheduler.setRemoveOnCancelPolicy(true);
        return threadPoolScheduler;
    }
}
