package com.biz.crm.websocket.controller;

import com.biz.crm.excel.component.ExportHelper;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.websocket.vo.WebsocketMsg;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.websocket.controller
 * @Description: TODO
 * @date 2021/3/31 下午3:27
 */
@Slf4j
@RestController
@RequestMapping("/common/websocket")
public class WebsocketController {

    @Resource
    private ExportHelper exportHelper;

    /**
     * 公用发送websockt 消息
     * @param websocketMsg
     * @return
     */
    @PostMapping("/sendMsg")
    public Result sendMsg(@RequestBody WebsocketMsg websocketMsg) {
        if(StringUtils.isEmpty(websocketMsg.getSid())){
            return Result.error("请传入sid");
        }
        exportHelper.sendWebsocketMsgMQ(websocketMsg.getMsg(),websocketMsg.getSid());
        return Result.ok();
    }
}
