package com.biz.crm.websocket.user.endpoint;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.socket.*;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.websocket.user.endpoint
 * @Description: TODO
 * @date 2020/12/2 下午3:28
 */
@Slf4j
public class UserWebSocketHandler implements WebSocketHandler{
    //在线用户列表
    private static final Map<String, WebSocketSession> users;

    static {
        users = new HashMap<>();
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        log.info("连接websoct成功!");
        String ID = session.getAttributes().get("WEBSOCKET_USERID").toString();
        log.info(ID);
        if (ID != null) {
            users.put(ID, session);
//            session.sendMessage(new TextMessage(JSONObject.toJSONString(Result.ok("恭喜阿刚，调试成功"))));
            log.info("id:" + ID + ",session:" + session + "");
        }
        log.info("current user number is:"+users.size());
    }

    @Override
    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        try{
            //com.alibaba.fastjson.JSONException: syntax error, pos 1, line 1, column 2heartbeat
            //JSONObject jsonobject = JSONObject.parseObject((String)message.getPayload());
            log.info("websoct 接收到消息:{}", message.getPayload());
//            sendMessageToUser(2+"", new TextMessage("{\"message\":\"恭喜阿刚，调试成功\"}"));
        }catch (Exception e) {
            log.error("e",e);
        }
    }

    @Override
    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        if (session.isOpen()) {
            session.close();
        }
        log.error("websoct 连接异常", exception);
        users.remove(getClientId(session));
    }

    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        log.info("websoct 连接被关闭" + closeStatus);
        users.remove(getClientId(session));
    }

    @Override
    public boolean supportsPartialMessages() {
        return false;
    }

    /**
     * 发送信息给指定用户
     * @param clientId
     * @param message
     * @return
     */
    public boolean sendMessageToUser(String clientId, TextMessage message) {
        if (users.get(clientId) == null) return false;
        WebSocketSession session = users.get(clientId);
        log.info("websoct 给用户发送消息:" + message);
        if (!session.isOpen()) return false;
        try {
            session.sendMessage(message);
        } catch (IOException e) {
            log.error("e", e);
            return false;
        }
        return true;
    }

    /**
     * 广播信息
     * @param message
     * @return
     */
    public boolean sendMessageToAllUsers(TextMessage message) {
        boolean allSendSuccess = true;
        Set<String> clientIds = users.keySet();
        WebSocketSession session = null;
        for (String clientId : clientIds) {
            try {
                session = users.get(clientId);
                if (session.isOpen()) {
                    session.sendMessage(message);
                }
            } catch (IOException e) {
                log.error("e", e);
                allSendSuccess = false;
            }
        }
        return allSendSuccess;
    }

    /**
     * 获取用户标识
     * @param session
     * @return
     */
    private String getClientId(WebSocketSession session) {
        try {
            String clientId = (String) session.getAttributes().get("WEBSOCKET_USERID");
            return clientId;
        } catch (Exception e) {
            log.error("e", e);
            return null;
        }
    }
    /**
     * 获取在线人数
     * @return
     */
    public synchronized int getOnlineNum(){
        return users.size();
    }

    /**
     * 获取websocketSession 判断是否为空
     * @param clientId
     * @return
     */
    public Boolean getWebSocketSession(String clientId){
        Boolean flag = false;
        WebSocketSession session = users.get(clientId);
        if (session != null && session.isOpen()){
            flag = true;
        }
        return flag;
    }
}
