/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.controller;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.excel.controller.req.ExcelImportParamVo;
import com.biz.crm.excel.service.ExcelImport;
import com.biz.crm.excel.util.DefaultExcelImportListener;
import com.biz.crm.excel.util.ExcelExportUtil;
import com.biz.crm.excel.util.ExcelImportParam;
import com.biz.crm.excel.util.ExcelImportSaver;
import com.biz.crm.excel.util.ExcelImportValidator;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"excelImportController"})
@Api(tags={"\u5bfc\u5165excel "})
public class ExcelImportController {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportController.class);
    @Resource(name="defaultExcelImport")
    private ExcelImport defaultExcelImport;
    @Resource(name="excelExportUtil")
    private ExcelExportUtil excelExportUtil;

    @ApiOperation(value="\u5bfc\u5165excel")
    @PostMapping(value={"import"})
    @CrmLog
    public Result doImport(@RequestPart(value="file") MultipartFile file) {
        ExcelImportParamVo paramVo = new ExcelImportParamVo();
        if (null == file) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6587\u4ef6");
        }
        ExcelImportParam excelImportParam = new ExcelImportParam();
        try {
            excelImportParam.setInputStream(file.getInputStream());
        }
        catch (IOException e) {
            log.warn("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        excelImportParam.setWebSocketClientId(paramVo.getWebSocketClientId());
        DefaultExcelImportListener listener = null;
        try {
            ExcelImportSaver excelImportSaver = (ExcelImportSaver)SpringApplicationContextUtil.getApplicationContext().getBean(paramVo.getBeanNameAsSaver(), ExcelImportSaver.class);
            ExcelImportValidator excelImportValidator = (ExcelImportValidator)SpringApplicationContextUtil.getApplicationContext().getBean(paramVo.getBeanNameAsValidator(), ExcelImportValidator.class);
            listener = new DefaultExcelImportListener(excelImportValidator, excelImportSaver, paramVo.getWebSocketClientId());
            excelImportParam.setListener(listener);
        }
        catch (Exception e) {
            log.warn("\u672a\u627e\u5230 ExcelImportSaver/ExcelImportValidator \u5b9e\u4f8b\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u672a\u627e\u5230 ExcelImportSaver/ExcelImportValidator \u5b9e\u4f8b\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        this.defaultExcelImport.doImport(excelImportParam);
        return Result.ok();
    }

    @ApiOperation(value="\u5bfc\u5165excel,\u4e0b\u8f7d\u793a\u4f8b\u6587\u4ef6")
    @GetMapping(value={"demoFile"})
    @CrmLog
    public Result demoFile(@ApiParam(value="\u5bfc\u5165\u5bf9\u8c61\u7684\u7c7b\u8def\u5f84") @RequestParam String classPathAsImportVo, @ApiParam(value="\u6587\u4ef6\u540d") @RequestParam String fileName) {
        if (StringUtils.isBlank((CharSequence)classPathAsImportVo)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u6587\u4ef6");
        }
        Class<?> importVoClass = null;
        try {
            importVoClass = Class.forName(classPathAsImportVo);
        }
        catch (ClassNotFoundException e) {
            log.warn("\u4e0d\u5b58\u5728\u7684\u5bfc\u5165\u5bf9\u8c61\u7c7b\u8def\u5f84[" + classPathAsImportVo + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5bfc\u5165\u5bf9\u8c61\u7c7b\u8def\u5f84[" + classPathAsImportVo + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        fileName = fileName + "\u793a\u4f8b";
        this.excelExportUtil.createExcelFile(fileName, importVoClass, ExcelTypeEnum.XLSX, Lists.newArrayList());
        return Result.ok((String)"\u793a\u4f8b\u6587\u4ef6\u5df2\u751f\u6210\uff0c\u8bf7\u524d\u5f80\u4e0b\u8f7d\u4e2d\u5fc3\u67e5\u770b");
    }
}

