/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.restTemplate.RestTemplateUtils;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.excel.service.IExcelService;
import com.biz.crm.excel.util.ExcelExportUtil;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.TextMessage;

@Service
@ConditionalOnMissingBean(name={"ExcelServiceImpl"})
public class ExcelServiceImpl
implements IExcelService {
    private static final Logger log = LoggerFactory.getLogger(ExcelServiceImpl.class);
    private static final String LOGIN_FIELD = "loginUserToken";
    @Resource
    private ExcelExportUtil excelExportUtil;
    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();
    @Value(value="${excel.export.excelUrl.save}")
    private String EXCEL_URL_SAVE;
    @Value(value="${excel.export.excelUrl.update}")
    private String EXCEL_URL_UPDATE;
    @Value(value="${excel.export.url}")
    private String URL;
    @Value(value="${excel.export.functionUrl}")
    private String EXCEL_FUNCTION_URL;
    @Resource
    private RestTemplateUtils restTemplateUtils;
    @Autowired
    private RocketMQProducer rocketMQProducer;

    @Override
    public void checkWebSocketSession(final JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"sid")) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230websocket\u8fde\u63a5");
        }
        RocketMQMessageBody body = new RocketMQMessageBody(){
            {
                this.setTag("WEBSOCKET_SESSION");
                this.setMsgBody(JSONObject.toJSONString((Object)jsonObject));
            }
        };
        this.rocketMQProducer.convertAndSend(body);
    }

    @Override
    public void repeatedWriteExport(JSONObject jsonObject) {
        String clientId = jsonObject.get((Object)"sid").toString();
        String token = UserUtils.getToken();
        AssertUtils.isNotEmpty((String)token, (String)"\u83b7\u53d6\u767b\u9646\u4eba\u4fe1\u606f\u4e3a\u7a7a");
        String id = this.saveExcelFile(jsonObject, token);
        String result = this.excelExportUtil.repeatedWrite(jsonObject, token);
        String data = this.updateExcelFile(id, result, token);
        JSONObject response = JSONObject.parseObject((String)data);
        if (response.containsKey((Object)"success") && ((Boolean)response.get((Object)"success")).booleanValue()) {
            userWebSocketHandler.sendMessageToUser(clientId, new TextMessage((CharSequence)JSONObject.toJSONString((Object)Result.ok((String)"\u5bfc\u51fa\u5b8c\u6210,\u8bf7\u5230\u4e0b\u8f7d\u4e2d\u5fc3\u8fdb\u884c\u4e0b\u8f7d"))));
        }
    }

    private String saveExcelFile(JSONObject data, String token) {
        String requestParam = this.checkSaveParam(data, token);
        String requestUrl = this.URL + this.EXCEL_URL_SAVE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set(LOGIN_FIELD, token);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"data", (Object)requestParam);
        HttpEntity httpEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        String result = RestTemplateUtils.postForObject(requestUrl, httpEntity);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (!(jsonObject.containsKey((Object)"success") && ((Boolean)jsonObject.get((Object)"success")).booleanValue() || !jsonObject.containsKey((Object)"result"))) {
            throw new BusinessException("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25");
        }
        String id = jsonObject.get((Object)"result").toString();
        return id;
    }

    private String checkSaveParam(JSONObject requestParam, String token) {
        JSONObject jsonObject = new JSONObject();
        String result = null;
        if (!(requestParam.containsKey((Object)"excelFileName") && requestParam.containsKey((Object)"parentCode") && requestParam.containsKey((Object)"functionCode"))) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\u4fe1\u606f:\u6587\u4ef6\u540d\u79f0/\u529f\u80fd\u7f16\u7801/\u83dc\u5355\u7f16\u7801");
        }
        String functionName = this.getFunctionName(requestParam, token);
        jsonObject.put("excelFileName", requestParam.get((Object)"excelFileName"));
        jsonObject.put("fileParam", (Object)JSONObject.toJSONString((Object)requestParam));
        jsonObject.put("fileSource", (Object)functionName);
        jsonObject.put("fileStatus", (Object)UploadEnum.fileStatus.IN_EXECUTION.getVal());
        result = JSONObject.toJSONString((Object)jsonObject);
        return result;
    }

    private String updateExcelFile(String id, String request, String token) {
        String data = this.checkUpdateParam(request, id);
        String requestUrl = this.URL + this.EXCEL_URL_UPDATE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set(LOGIN_FIELD, token);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"data", (Object)data);
        HttpEntity httpEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        String result = RestTemplateUtils.postForObject(requestUrl, httpEntity);
        return result;
    }

    private String getFunctionName(JSONObject jsonObject, String token) {
        String functionName = null;
        try {
            String parentCode = jsonObject.get((Object)"parentCode").toString();
            String functionCode = jsonObject.get((Object)"functionCode").toString();
            JSONObject requestParam = new JSONObject();
            requestParam.put("parentCode", (Object)parentCode);
            requestParam.put("functionCode", (Object)functionCode);
            String requestUrl = this.URL + this.EXCEL_FUNCTION_URL;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.set(LOGIN_FIELD, token);
            ResponseEntity<Result> response = RestTemplateUtils.postForEntity(requestUrl, headers, requestParam, Result.class);
            Result result = (Result)response.getBody();
            MdmFunctionSubRespVo mdmFunctionSubRespVo = (MdmFunctionSubRespVo)new Gson().fromJson(new Gson().toJson(result.getResult()), new TypeToken<MdmFunctionSubRespVo>(){}.getType());
            functionName = mdmFunctionSubRespVo.getFunctionName();
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u529f\u80fd\u540d\u79f0\u5931\u8d25!");
        }
        return functionName;
    }

    private String checkUpdateParam(String request, String id) {
        JSONObject jsonObject = JSONObject.parseObject((String)request);
        JSONObject requestParam = new JSONObject();
        if (!(jsonObject.containsKey((Object)"result") && jsonObject.containsKey((Object)"success") && ((Boolean)jsonObject.get((Object)"success")).booleanValue())) {
            requestParam.put("fileStatus", (Object)UploadEnum.fileStatus.FAIL.getVal());
            requestParam.put("id", (Object)id);
        } else {
            String result = jsonObject.get((Object)"result").toString();
            JSONObject excelJsonObject = JSONObject.parseObject((String)JSONObject.parseArray((String)result).get(0).toString());
            requestParam.put("fileName", excelJsonObject.get((Object)"fileName"));
            requestParam.put("objectName", excelJsonObject.get((Object)"objectName"));
            requestParam.put("filePath", excelJsonObject.get((Object)"url"));
            requestParam.put("fileStatus", (Object)UploadEnum.fileStatus.SUCCESS.getVal());
            requestParam.put("id", (Object)id);
        }
        return JSONObject.toJSONString((Object)requestParam);
    }
}

