/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.excel.util.AbstractImportVo;
import com.biz.crm.excel.util.ExcelExportUtil;
import com.biz.crm.excel.util.ExcelImportSaver;
import com.biz.crm.excel.util.ExcelImportValidator;
import com.biz.crm.excel.util.MqMessageParam;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.util.JsonPropertyUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultExcelImportListener<T extends AbstractImportVo>
extends AnalysisEventListener<T> {
    private RocketMQProducer rocketMQProducer = (RocketMQProducer)SpringApplicationContextUtil.getApplicationContext().getBean("rocketMQProducer", RocketMQProducer.class);
    private RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
    private ExcelExportUtil excelExportUtil = (ExcelExportUtil)SpringApplicationContextUtil.getApplicationContext().getBean("excelExportUtil", ExcelExportUtil.class);
    private Class dataClass;
    private int processNo = 30;
    private String webSocketClientId;
    private List<T> dataCache = Lists.newArrayList();
    private ExcelImportValidator<T> validator;
    private ExcelImportSaver<T> saver;

    public DefaultExcelImportListener(ExcelImportValidator<T> validator, ExcelImportSaver<T> saver, String webSocketClientId) {
        this.validator = validator;
        this.saver = saver;
        this.webSocketClientId = webSocketClientId;
    }

    public void invoke(T data, AnalysisContext context) {
        this.dataClass = data.getClass();
        ReadRowHolder rowHolder = context.readRowHolder();
        if (null != rowHolder) {
            ((AbstractImportVo)data).setRowIndex(rowHolder.getRowIndex());
        }
        this.dataCache.add(data);
        this.doProcess(false, context);
    }

    private void doProcess(boolean finish, AnalysisContext context) {
        this.validate(finish);
        this.save(finish);
        this.sendDataCacheMsg(finish);
        this.createFailDataExcel(finish, context.readWorkbookHolder().getExcelType());
    }

    private void validate(boolean finish) {
        if (this.processNo >= this.dataCache.size() || finish) {
            boolean process = true;
            String msg = null;
            try {
                this.validator.validate(this.dataCache);
            }
            catch (BusinessException e) {
                process = false;
                msg = e.getMsg();
            }
            catch (Exception e) {
                process = false;
                msg = e.getMessage();
            }
            if (!process) {
                for (AbstractImportVo data : this.dataCache) {
                    data.setProcessType(AbstractImportVo.ProcessTypeEnum.SUCCESS);
                    data.setValidateMsg(msg);
                }
            }
        }
    }

    private void save(boolean finish) {
        if (this.processNo >= this.dataCache.size() || finish) {
            boolean process = true;
            String msg = null;
            try {
                this.saver.save(this.dataCache);
            }
            catch (BusinessException e) {
                process = false;
                msg = e.getMsg();
            }
            catch (Exception e) {
                process = false;
                msg = e.getMessage();
            }
            if (!process) {
                for (AbstractImportVo data : this.dataCache) {
                    data.setProcessType(AbstractImportVo.ProcessTypeEnum.SUCCESS);
                    data.setSaveMsg(msg);
                }
            }
            this.dataCache = Lists.newArrayList();
        }
    }

    private void sendDataCacheMsg(boolean finish) {
        if (this.processNo >= this.dataCache.size() || finish) {
            MqMessageParam mqMessageParam = new MqMessageParam();
            mqMessageParam.setClientId(this.webSocketClientId);
            mqMessageParam.setMsg(this.buildDataCacheMsg());
            this.sendMQ(JsonPropertyUtil.toJsonString((Object)mqMessageParam));
        }
    }

    private void sendMQ(String msgBody) {
        this.mqMessageBody.setTag("EXCEL_IMPORT_WEBSOCKET_MSG");
        this.mqMessageBody.setMsgBody(msgBody);
        this.rocketMQProducer.convertAndSend(this.mqMessageBody);
    }

    private void createFailDataExcel(boolean finish, ExcelTypeEnum excelTypeEnum) {
        if (this.processNo >= this.dataCache.size() || finish) {
            Map<AbstractImportVo.ProcessTypeEnum, List<AbstractImportVo>> typeMapData = this.dataCache.stream().collect(Collectors.groupingBy(AbstractImportVo::getProcessType));
            List<AbstractImportVo> dataAsFail = typeMapData.get((Object)AbstractImportVo.ProcessTypeEnum.FAIL);
            int size = dataAsFail.size();
            if (size == 0) {
                return;
            }
            String excelFileName = ((AbstractImportVo)this.dataCache.get(0)).getRowIndex() + "\u884c-" + ((AbstractImportVo)this.dataCache.get(this.dataCache.size() - 1)).getRowIndex() + "\u884c\u5904\u7406\u5931\u8d25\u6570\u636e";
            this.excelExportUtil.createExcelFile(excelFileName, this.dataClass, excelTypeEnum, dataAsFail);
            MqMessageParam mqMessageParam = new MqMessageParam();
            mqMessageParam.setClientId(this.webSocketClientId);
            mqMessageParam.setMsg("\u5f53\u524d\u5b50\u4efb\u52a1" + size + "\u6761\u6570\u636e\u5904\u7406\u5931\u8d25\uff1a\u5df2\u63a8\u9001\u81f3\u4e0b\u8f7d\u4e2d\u5fc3 -> " + excelFileName);
            this.sendMQ(JsonPropertyUtil.toJsonString((Object)mqMessageParam));
            this.dataCache = Lists.newArrayList();
        }
    }

    private String buildDataCacheMsg() {
        StringBuilder msg = new StringBuilder();
        int i = 0;
        for (AbstractImportVo data : this.dataCache) {
            if (i > 0) {
                msg.append("\n");
            }
            msg.append("\u7b2c");
            msg.append(data.getRowIndex());
            msg.append("\u884c\uff1a");
            msg.append(data.getValidateMsg());
            msg.append(" -> ");
            msg.append(data.getSaveMsg());
            ++i;
        }
        return msg.toString();
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.doProcess(true, context);
    }

    public List<T> getDataCache() {
        return this.dataCache;
    }
}

