/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.restTemplate.RestTemplateUtils;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.TextMessage;

@Component
public class ExcelExportUtil {
    @Value(value="${excel.export.basdir}")
    private String EXCEL_EXPORT_BASDIR;
    @Value(value="${excel.export.url}")
    private String URL;
    private static final String LOGIN_FIELD = "loginUserToken";
    @Value(value="${excel.export.headUrl}")
    private String HEADER_URL;
    @Value(value="${excel.export.uploadUrl}")
    private String UPLOAD_URL;
    private static final Integer PAGE_SIZE = 100;
    private static final Integer PAGE_NUM = 1;
    public static final DateTimeFormatter yyyyMMddHHmmss = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();
    @Resource
    private RestTemplateUtils restTemplateUtils;

    private void againWrite(Integer size, List<?> data, WriteSheet writeSheet, ExcelWriter excelWriter, String clientId) {
        excelWriter.write(data, writeSheet);
        userWebSocketHandler.sendMessageToUser(clientId, new TextMessage((CharSequence)JSONObject.toJSONString((Object)Result.ok((String)("\u6210\u529f\u5bfc\u51fa" + size * data.size() + "\u6761\u6570\u636e!")))));
    }

    private List<List<String>> head(Map<String, String> map) {
        ArrayList listList = Lists.newArrayList();
        for (Map.Entry<String, String> m : map.entrySet()) {
            ArrayList<String> headList = new ArrayList<String>();
            headList.add(m.getValue());
            listList.add(headList);
        }
        return listList;
    }

    private Result getPageData(JSONObject jsonObject, String requestUrl, String token) {
        requestUrl = this.URL + requestUrl;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(LOGIN_FIELD, token);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(requestUrl, headers, jsonObject, Result.class);
        Result result = (Result)response.getBody();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String repeatedWrite(JSONObject jsonObject, String token) {
        String excelFileName;
        AssertUtils.isNotEmpty((String)token, (String)"\u767b\u9646\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        if (!(jsonObject != null && jsonObject.containsKey((Object)"excelFileName") && jsonObject.containsKey((Object)"sid") && jsonObject.containsKey((Object)"parentCode") && jsonObject.containsKey((Object)"functionCode") && jsonObject.containsKey((Object)"requestUrl"))) {
            throw new BusinessException("\u53c2\u6570\u4e3a\u7a7a");
        }
        jsonObject.put("pageNum", (Object)PAGE_NUM);
        jsonObject.put("pageSize", (Object)PAGE_SIZE);
        String clientId = jsonObject.get((Object)"sid").toString();
        String sheetName = excelFileName = LocalDateTime.now().format(yyyyMMddHHmmss) + "_" + jsonObject.get((Object)"excelFileName").toString();
        String requestUrl = jsonObject.get((Object)"requestUrl").toString();
        JSONObject headJson = new JSONObject();
        headJson.put("parentCode", jsonObject.get((Object)"parentCode"));
        headJson.put("functionCode", jsonObject.get((Object)"functionCode"));
        Map<String, String> headMap = this.getExcelHeadList(headJson, token);
        Result result = this.getPageData(jsonObject, requestUrl, token);
        JSONObject json1 = (JSONObject)JSON.toJSON((Object)result.getResult());
        Integer count = Integer.valueOf(json1.get((Object)"count").toString());
        Integer num = count / PAGE_SIZE;
        if (count % PAGE_SIZE > 0) {
            num = num + 2;
        }
        String a = json1.get((Object)"data").toString();
        JSONArray jsonArray = JSON.parseArray((String)a);
        ArrayList<Map> maps = new ArrayList<Map>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject j = jsonArray.getJSONObject(i);
            Map map = (Map)JSONObject.parseObject((String)j.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            maps.add(map);
        }
        ArrayList dataList = new ArrayList();
        for (Map data : maps) {
            ArrayList obj = new ArrayList();
            for (Map.Entry<String, String> map : headMap.entrySet()) {
                obj.add(data.get(map.getKey()));
            }
            dataList.add(obj);
        }
        String filePath = this.EXCEL_EXPORT_BASDIR + File.separator + excelFileName + ".xlsx";
        ExcelWriter excelWriter = null;
        try {
            List<List<String>> headList = this.head(headMap);
            excelWriter = ((ExcelWriterBuilder)EasyExcel.write((String)filePath).head(headList)).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((String)sheetName).build();
            this.againWrite(dataList.size(), dataList, writeSheet, excelWriter, clientId);
            this.againGetPageData(num, token, requestUrl, jsonObject, headMap, writeSheet, excelWriter, clientId);
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
        String jsonResult = this.uploadFile(filePath, token, excelFileName);
        return jsonResult;
    }

    private void againGetPageData(Integer num, String token, String requestUrl, JSONObject jsonObject, Map<String, String> headMap, WriteSheet writeSheet, ExcelWriter excelWriter, String clientId) {
        for (int i = 2; i < num; ++i) {
            jsonObject.put("pageNum", (Object)i);
            Result againResult = this.getPageData(jsonObject, requestUrl, token);
            JSONObject toJSON = (JSONObject)JSON.toJSON((Object)againResult.getResult());
            String str = toJSON.get((Object)"data").toString();
            JSONArray jsonArray = JSON.parseArray((String)str);
            ArrayList<Map> maps = new ArrayList<Map>();
            for (int j = 0; j < jsonArray.size(); ++j) {
                JSONObject job = jsonArray.getJSONObject(j);
                Map map = (Map)JSONObject.parseObject((String)job.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                maps.add(map);
            }
            ArrayList dataList = new ArrayList();
            for (Map data : maps) {
                ArrayList obj = new ArrayList();
                for (Map.Entry<String, String> map : headMap.entrySet()) {
                    obj.add(data.get(map.getKey()));
                }
                dataList.add(obj);
            }
            Integer size = i++;
            this.againWrite(dataList.size() * size, dataList, writeSheet, excelWriter, clientId);
        }
    }

    private Map<String, String> getExcelHeadList(JSONObject excelHeadRequest, String token) {
        String requestUrl = this.URL + this.HEADER_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(LOGIN_FIELD, token);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(requestUrl, headers, excelHeadRequest, Result.class);
        Result result = (Result)response.getBody();
        List mdmColumnExportRespVos = (List)new Gson().fromJson(new Gson().toJson(result.getResult()), new TypeToken<List<MdmColumnExportRespVo>>(){}.getType());
        mdmColumnExportRespVos = mdmColumnExportRespVos.stream().filter(data -> StringUtils.isNotEmpty((String)data.getField()) && StringUtils.isNotEmpty((String)data.getTitle())).collect(Collectors.toList());
        Map<String, String> map = mdmColumnExportRespVos.stream().collect(Collectors.toMap(MdmColumnExportRespVo::getField, MdmColumnExportRespVo::getTitle));
        return map;
    }

    public String uploadFile(String urlFile, String token, String excelName) {
        String requestUrl = this.URL + this.UPLOAD_URL;
        String fileName = excelName + ".xlsx";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set(LOGIN_FIELD, token);
        FileSystemResource fileSystemResource = new FileSystemResource(urlFile);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"file", (Object)fileSystemResource);
        form.add((Object)"filename", (Object)fileName);
        HttpEntity httpEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        String result = RestTemplateUtils.postForObject(requestUrl, httpEntity);
        return result;
    }

    public void createExcelFile(String excelFileName, Class classObj, ExcelTypeEnum excelTypeEnum, List<?> data) {
        if (CollectionUtils.isEmpty(data) || null == classObj || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)excelFileName)) {
            return;
        }
        if (null == excelTypeEnum) {
            excelTypeEnum = ExcelTypeEnum.XLS;
        }
        String filePath = this.EXCEL_EXPORT_BASDIR + File.separator + excelFileName + excelTypeEnum.getValue();
        EasyExcel.write((String)filePath, (Class)classObj).sheet("sheet1").doWrite(data);
        this.uploadFile(filePath, UserUtils.getToken(), excelFileName);
    }
}

