/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.sfa;

import com.alibaba.excel.context.AnalysisContext;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.vo.TestImportVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="testValidator")
public class TestValidator
implements ExcelImportValidator<TestImportVo> {
    private static final Logger log = LoggerFactory.getLogger(TestValidator.class);

    @Override
    public void validate(List<TestImportVo> data, AnalysisContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        String temp = "admin,test-user1,test-user2";
        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)v.getFullName())) {
                msg.append("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a;");
            }
            if (StringUtils.isBlank((CharSequence)v.getUserName())) {
                msg.append("\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (temp.contains(v.getUserName())) {
                msg.append("\u5df2\u5b58\u5728\u7684\u7528\u6237\u8d26\u53f7;");
            }
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                v.appendErrorValidateMsg(msg.toString());
            }
        });
    }
}

