/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.excel.controller.req.ExcelImportParamVo;
import com.biz.crm.excel.controller.resp.DemoFileResp;
import com.biz.crm.excel.service.ExcelImport;
import com.biz.crm.excel.util.DefaultExcelImportListener;
import com.biz.crm.excel.util.ExcelImportUtil;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.upload.excel.ExcelExportFeign;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.File;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component(value="defaultExcelImport")
public class DefaultExcelImport
implements ExcelImport {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelImport.class);
    @Value(value="${excel.export.downloadUrl}")
    private String EXCEL_DOWNLOAD_URL;
    @Resource
    private ExcelExportFeign excelExportFeign;

    @Override
    @Async
    public void doImport(ExcelImportParamVo paramVo, String token, File file) {
        block2: {
            try {
                UserUtils.setToken((String)token);
                DefaultExcelImportListener listener = new DefaultExcelImportListener(paramVo);
                listener.setEXCEL_DOWNLOAD_URL(this.EXCEL_DOWNLOAD_URL);
                EasyExcel.read((File)file, (Class)this.getClazz(paramVo.getClassPathAsImportVo()), listener).sheet().doRead();
            }
            catch (Exception e) {
                ExcelExportReqVo excelExportReqVo = new ExcelExportReqVo();
                excelExportReqVo.setId(paramVo.getTaskId());
                excelExportReqVo.setFileStatus(UploadEnum.fileStatus.IMPORT_EXCEPTION.getVal());
                excelExportReqVo.setRemarks(e.getMessage());
                Result result = this.excelExportFeign.update(excelExportReqVo);
                if (ApiResultUtil.checkResult((Result)result)) break block2;
                log.error("\u5bfc\u5165\u5f02\u5e38>>>>>", (Throwable)e);
            }
        }
    }

    @Override
    public DemoFileResp demoFile(String importConfigCode) {
        ExcelImportParamVo excelImportParamVo = this.resolveConfig(importConfigCode);
        String fileName = excelImportParamVo.getFileNameAsDemo();
        File file = ExcelImportUtil.writeFile(fileName, this.getClazz(excelImportParamVo.getClassPathAsImportVo()), ExcelTypeEnum.XLSX, Lists.newArrayList(), AbstractImportVo.BASE_IMPORT_COLUMNS);
        DemoFileResp demoFileResp = (DemoFileResp)CrmBeanUtil.copy((Object)excelImportParamVo, DemoFileResp.class);
        demoFileResp.setFile(file);
        return demoFileResp;
    }

    @Override
    public ExcelImportParamVo resolveConfig(String configCode) {
        String config = (String)DictUtil.getDictValueMapsByCodes((String)"excel_import_config").get(configCode);
        if (StringUtils.isBlank((CharSequence)config)) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        ExcelImportParamVo paramVo = (ExcelImportParamVo)JsonPropertyUtil.toObject((String)config, ExcelImportParamVo.class);
        if (null == paramVo) {
            throw new BusinessException("\u89e3\u6790\u5bfc\u5165\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        if (StringUtils.isBlank((CharSequence)paramVo.getBeanNameAsTransactionManager())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u4e8b\u52a1\u7ba1\u7406\u5668[beanNameAsTransactionManager]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        if (StringUtils.isBlank((CharSequence)paramVo.getBeanNameAsSaver())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u4fdd\u5b58\u903b\u8f91[beanNameAsSaver]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        if (StringUtils.isBlank((CharSequence)paramVo.getBeanNameAsValidator())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u6821\u9a8c\u903b\u8f91[beanNameAsValidator]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        if (StringUtils.isBlank((CharSequence)paramVo.getClassPathAsImportVo())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u89e3\u6790\u7c7b\u8def\u5f84[classPathAsImportVo]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        if (StringUtils.isBlank((CharSequence)paramVo.getFileNameAsDemo())) {
            throw new BusinessException("\u5fc5\u987b\u914d\u7f6e\u793a\u4f8b\u6587\u4ef6\u540d[fileNameAsDemo]\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5b57\u5178\u68c0\u67e5Excel\u5bfc\u5165\u914d\u7f6e[" + configCode + "]");
        }
        paramVo.setImportConfigCode(configCode);
        return paramVo;
    }

    private Class getClazz(String classPathAsImportVo) {
        if (StringUtils.isBlank((CharSequence)classPathAsImportVo)) {
            throw new BusinessException("excel \u884c\u89e3\u6790\u7c7b\u8def\u5f84");
        }
        try {
            return Class.forName(classPathAsImportVo);
        }
        catch (ClassNotFoundException e) {
            log.warn("\u4e0d\u5b58\u5728\u7684\u884c\u89e3\u6790\u7c7b\u8def\u5f84[" + classPathAsImportVo + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u884c\u89e3\u6790\u7c7b\u8def\u5f84[" + classPathAsImportVo + "]\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }
}

