/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.controller.req.ExcelImportParamVo;
import com.biz.crm.excel.util.ExcelExportUtil;
import com.biz.crm.excel.util.MqMessageParam;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.upload.excel.ExcelExportFeign;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.ResultUtil;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;

public class DefaultExcelImportListener<T extends AbstractImportVo>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelImportListener.class);
    private DataSourceTransactionManager transactionManager;
    private RocketMQProducer rocketMQProducer = (RocketMQProducer)SpringApplicationContextUtil.getApplicationContext().getBean("rocketMQProducer", RocketMQProducer.class);
    private RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
    private ExcelExportUtil excelExportUtil = (ExcelExportUtil)SpringApplicationContextUtil.getApplicationContext().getBean("excelExportUtil", ExcelExportUtil.class);
    private ExcelExportFeign excelExportFeign = (ExcelExportFeign)SpringApplicationContextUtil.getApplicationContext().getBean(ExcelExportFeign.class);
    private Class dataClass;
    private String EXCEL_DOWNLOAD_URL;
    private ExcelImportParamVo importParamVo;
    private int processNo = 999;
    private String webSocketClientId;
    private List<T> dataCache = Lists.newArrayList();
    private List<T> dataAsFail = Lists.newArrayList();
    private long dataTotal = 0L;
    private LocalDateTime beginDateTime = LocalDateTime.now();
    private ExcelImportValidator<T> validator;
    private ExcelImportSaver<T> saver;
    private TransactionStatus transactionStatus;
    private boolean initTag = false;

    private void doProcess(boolean finish, AnalysisContext context) {
        this.validate(finish, context);
        this.save(finish, context);
        this.sendDataCacheMsg(finish);
    }

    private void init() {
        if (this.initTag) {
            return;
        }
        if (null == this.importParamVo) {
            throw new BusinessException("\u65e0\u6548\u7684\u5bfc\u5165\u914d\u7f6e\u53c2\u6570");
        }
        try {
            this.transactionManager = (DataSourceTransactionManager)SpringApplicationContextUtil.getApplicationContext().getBean(this.importParamVo.getBeanNameAsTransactionManager(), DataSourceTransactionManager.class);
            this.saver = (ExcelImportSaver)SpringApplicationContextUtil.getApplicationContext().getBean(this.importParamVo.getBeanNameAsSaver(), ExcelImportSaver.class);
            this.validator = (ExcelImportValidator)SpringApplicationContextUtil.getApplicationContext().getBean(this.importParamVo.getBeanNameAsValidator(), ExcelImportValidator.class);
        }
        catch (Exception e) {
            log.warn("\u672a\u627e\u5230 ExcelImportSaver/ExcelImportValidator/TransactionManager \u5b9e\u4f8b\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u672a\u627e\u5230 ExcelImportSaver/ExcelImportValidator/TransactionManager \u5b9e\u4f8b\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        this.webSocketClientId = this.importParamVo.getWebSocketClientId();
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        this.transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)def);
        this.initTag = true;
    }

    public DefaultExcelImportListener(ExcelImportParamVo importParamVo) {
        this.importParamVo = importParamVo;
    }

    public void invoke(T data, AnalysisContext context) {
        this.init();
        ++this.dataTotal;
        try {
            this.dataClass = data.getClass();
            ReadRowHolder rowHolder = context.readRowHolder();
            if (null != rowHolder) {
                data.setRowIndex(rowHolder.getRowIndex());
            }
            this.dataCache.add(data);
            this.doProcess(false, context);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5f02\u5e38>>>>>>", (Throwable)e);
            this.transactionManager.rollback(this.transactionStatus);
            this.sendMQ("\u5bfc\u5165\u5f02\u5e38");
            throw e;
        }
    }

    private void validate(boolean finish, AnalysisContext context) {
        if (this.dataCache.size() >= this.processNo || finish) {
            boolean process = true;
            String msg = null;
            try {
                this.validator.validate(this.dataCache, context);
            }
            catch (BusinessException e) {
                process = false;
                msg = e.getMsg();
            }
            catch (Exception e) {
                process = false;
                msg = e.getMessage();
            }
            if (!process) {
                for (AbstractImportVo data : this.dataCache) {
                    data.setProcessType(AbstractImportVo.ProcessTypeEnum.SUCCESS);
                    data.appendErrorValidateMsg(msg);
                }
            }
        }
    }

    private void save(boolean finish, AnalysisContext context) {
        if (this.dataCache.size() >= this.processNo || finish) {
            boolean process = true;
            String msg = null;
            try {
                this.saver.save(this.dataCache, context);
            }
            catch (BusinessException e) {
                process = false;
                msg = e.getMsg();
            }
            catch (Exception e) {
                process = false;
                msg = e.getMessage();
            }
            if (!process) {
                for (AbstractImportVo data : this.dataCache) {
                    data.setProcessType(AbstractImportVo.ProcessTypeEnum.FAIL);
                    data.appendErrorSaveMsg(msg);
                }
            }
            this.cacheFailData();
        }
    }

    private void cacheFailData() {
        Map<AbstractImportVo.ProcessTypeEnum, List<AbstractImportVo>> typeMapData = this.dataCache.stream().collect(Collectors.groupingBy(AbstractImportVo::getProcessType));
        List<AbstractImportVo> dataAsFailTepm = typeMapData.get(AbstractImportVo.ProcessTypeEnum.FAIL);
        if (!CollectionUtils.isEmpty(dataAsFailTepm)) {
            this.dataAsFail.addAll(dataAsFailTepm);
        }
    }

    private void sendDataCacheMsg(boolean finish) {
        if (this.dataCache.size() >= this.processNo || finish) {
            MqMessageParam mqMessageParam = new MqMessageParam();
            mqMessageParam.setClientId(this.webSocketClientId);
            mqMessageParam.setMsg(this.buildDataCacheMsg());
            this.sendMQ(JsonPropertyUtil.toJsonString((Object)mqMessageParam));
            this.dataCache = Lists.newArrayList();
        }
    }

    private void sendMQ(String msgBody) {
        this.mqMessageBody.setTag("EXCEL_IMPORT_WEBSOCKET_MSG");
        this.mqMessageBody.setMsgBody(msgBody);
        this.rocketMQProducer.convertAndSend(this.mqMessageBody);
    }

    private void importFinish(AnalysisContext context) {
        ExcelExportReqVo excelExportReqVo = this.uploadFileAndBuildExcelExportReqVo(context);
        excelExportReqVo.setId(this.importParamVo.getTaskId());
        Result result = this.excelExportFeign.update(excelExportReqVo);
        if (!ApiResultUtil.checkResult((Result)result)) {
            throw new BusinessException("\u6587\u4ef6\u63a8\u9001\u5931\u8d25[" + result.getMessage() + "]\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        this.sendFinishMsg(excelExportReqVo);
    }

    private ExcelExportReqVo uploadFileAndBuildExcelExportReqVo(AnalysisContext context) {
        File baseFile = context.readWorkbookHolder().getFile();
        List resultAsBaseData = ResultUtil.listResultFromJsonStr((String)this.excelExportUtil.uploadFile(baseFile.getPath(), UserUtils.getToken(), baseFile.getName()), UploadVo.class, (boolean)true);
        if (CollectionUtils.isEmpty((Collection)resultAsBaseData)) {
            throw new BusinessException("\u539f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        UploadVo baseData = (UploadVo)resultAsBaseData.get(0);
        UploadVo failData = null;
        String failFileName = "\u5904\u7406\u5931\u8d25\u6570\u636e";
        if (!CollectionUtils.isEmpty(this.dataAsFail)) {
            List tepm = ResultUtil.listResultFromJsonStr((String)this.excelExportUtil.createExcelFile(failFileName, this.dataClass, context.readWorkbookHolder().getExcelType(), this.dataAsFail, null), UploadVo.class, (boolean)true);
            if (CollectionUtils.isEmpty((Collection)tepm)) {
                throw new BusinessException("\u5904\u7406\u5931\u8d25\u6570\u636e\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
            failData = (UploadVo)tepm.get(0);
        }
        return this.buildExcelExportReqVo(baseFile.getName(), baseData, failFileName, failData);
    }

    private ExcelExportReqVo buildExcelExportReqVo(String baseFileName, UploadVo baseData, String failFileName, UploadVo failData) {
        ExcelExportReqVo vo = new ExcelExportReqVo();
        vo.setObjectName(baseData.getObjectName());
        vo.setFilePath(baseData.getUrl());
        if (null != failData) {
            vo.setObjectNameAsImportFail(failData.getObjectName());
            vo.setFilePathAsImportFail(failData.getUrl());
            vo.setFileNameAsImportFail(failFileName);
            vo.setExcelFileNameAsImportFail(failFileName);
        }
        vo.setFileSource(this.importParamVo.getFileNameAsDemo());
        vo.setFileParam(this.importParamVo.getImportConfigCode());
        vo.setFileType(UploadEnum.fileType.IMPORT.getVal());
        vo.setFileStatus(UploadEnum.fileStatus.IMPORT_SUCCESS.getVal());
        vo.setBeginDate(this.beginDateTime.format(CrmDateUtils.yyyyMMddHHmmss));
        vo.setEndDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        return vo;
    }

    private void sendFinishMsg(ExcelExportReqVo excelExportReqVo) {
        StringBuilder msg = new StringBuilder("\u5f53\u524d\u4efb\u52a1\u6570\u636e\u603b\u884c\u6570\uff1a");
        msg.append(this.dataTotal);
        msg.append("\u6761\n");
        msg.append("\u6210\u529f\u6570\uff1a");
        msg.append(this.dataTotal - (long)this.dataAsFail.size());
        msg.append("\u6761\n");
        msg.append("\u5931\u8d25\u6570\uff1a");
        msg.append(this.dataAsFail.size());
        msg.append("\u6761");
        if (StringUtils.isNotBlank((CharSequence)excelExportReqVo.getObjectNameAsImportFail())) {
            msg.append("<a href='");
            msg.append(this.EXCEL_DOWNLOAD_URL);
            msg.append("?objectName=");
            msg.append(excelExportReqVo.getObjectNameAsImportFail());
            msg.append("'>[\u70b9\u51fb\u4e0b\u8f7d]</a>");
        }
        MqMessageParam mqMessageParam = new MqMessageParam();
        mqMessageParam.setClientId(this.webSocketClientId);
        mqMessageParam.setMsg(msg.toString());
        this.sendMQ(JsonPropertyUtil.toJsonString((Object)mqMessageParam));
    }

    private String buildDataCacheMsg() {
        StringBuilder msg = new StringBuilder();
        int i = 0;
        for (AbstractImportVo data : this.dataCache) {
            if (i > 0) {
                msg.append("\n");
            }
            msg.append("\u7b2c");
            msg.append(data.getRowIndex());
            msg.append("\u884c\uff08Excel\u884c\u53f7\uff09[\u6821\u9a8c: ");
            msg.append(data.getValidateMsg());
            msg.append(" -> \u4fdd\u5b58: ");
            msg.append(data.getSaveMsg());
            msg.append("]");
            ++i;
        }
        return msg.toString();
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        try {
            this.doProcess(true, context);
            this.importFinish(context);
            this.transactionManager.commit(this.transactionStatus);
        }
        catch (BusinessException e) {
            log.error("\u5bfc\u5165\u5f02\u5e38>>>>>>", (Throwable)e);
            this.transactionManager.rollback(this.transactionStatus);
            this.sendMQ("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMsg());
            throw e;
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5f02\u5e38>>>>>>", (Throwable)e);
            this.transactionManager.rollback(this.transactionStatus);
            this.sendMQ("\u5bfc\u5165\u5f02\u5e38");
            throw e;
        }
    }

    public void setEXCEL_DOWNLOAD_URL(String EXCEL_DOWNLOAD_URL) {
        this.EXCEL_DOWNLOAD_URL = EXCEL_DOWNLOAD_URL;
    }

    public ExcelImportParamVo getImportParamVo() {
        return this.importParamVo;
    }

    public int getProcessNo() {
        return this.processNo;
    }

    public void setProcessNo(int processNo) {
        this.processNo = processNo;
    }
}

