/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.restTemplate.RestTemplateUtils;
import com.biz.crm.excel.service.impl.ExcelServiceImpl;
import com.biz.crm.excel.util.ExcelImportUtil;
import com.biz.crm.mdm.columnconfig.MdmColumnConfigFeign;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.TextMessage;

@Component
public class ExcelExportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportUtil.class);
    @Value(value="${excel.export.basdir}")
    private String EXCEL_EXPORT_BASDIR;
    @Value(value="${excel.export.url}")
    private String URL;
    private static final String LOGIN_FIELD = "loginUserToken";
    @Value(value="${excel.export.uploadUrl}")
    private String UPLOAD_URL;
    private static final Integer PAGE_SIZE = 100;
    private static final Integer PAGE_NUM = 1;
    public static final DateTimeFormatter yyyyMMddHHmmss = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();
    @Resource
    private RestTemplateUtils restTemplateUtils;
    @Autowired
    private ExcelServiceImpl excelService;
    @Resource
    private MdmColumnConfigFeign mdmColumnConfigFeign;

    private void againWrite(Integer count, Integer alreadyNum, List<?> data, WriteSheet writeSheet, ExcelWriter excelWriter, String clientId) {
        excelWriter.write(data, writeSheet);
        this.sendWebSocketMessage(clientId, "\u5df2\u5199\u5165excel\uff1a" + alreadyNum + "/" + count + "\u6761\u6570\u636e");
    }

    private List<List<String>> head(Map<String, String> map) {
        ArrayList listList = Lists.newArrayList();
        for (Map.Entry<String, String> m : map.entrySet()) {
            ArrayList<String> headList = new ArrayList<String>();
            headList.add(m.getValue());
            listList.add(headList);
        }
        return listList;
    }

    private Result getPageData(JSONObject jsonObject, String requestUrl, String token, String clientId, String id) {
        try {
            jsonObject.remove((Object)"parentCode");
            jsonObject.remove((Object)"functionCode");
            requestUrl = this.URL + requestUrl;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.set(LOGIN_FIELD, token);
            ResponseEntity<Result> response = RestTemplateUtils.postForEntity(requestUrl, headers, jsonObject, Result.class);
            Result result = (Result)response.getBody();
            return result;
        }
        catch (Exception e) {
            this.sendWebSocketMessage(clientId, "\u8bfb\u53d6\u5217\u8868\u6570\u636e\u4fe1\u606f\u5931\u8d25!");
            JSONObject requestParam = new JSONObject();
            requestParam.put("success", (Object)false);
            this.excelService.updateFailExcelFile(id, JSONObject.toJSONString((Object)requestParam));
            throw new BusinessException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String repeatedWrite(JSONObject jsonObject, String token, String id) {
        AssertUtils.isNotEmpty((String)token, (String)"\u767b\u9646\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        jsonObject.put("pageNum", (Object)PAGE_NUM);
        jsonObject.put("pageSize", (Object)PAGE_SIZE);
        String clientId = jsonObject.get((Object)"sid").toString();
        String sheetName = jsonObject.get((Object)"functionName").toString();
        String excelFileName = jsonObject.get((Object)"excelFileName").toString();
        String requestUrl = jsonObject.get((Object)"requestUrl").toString();
        JSONObject headJson = new JSONObject();
        headJson.put("parentCode", jsonObject.get((Object)"parentCode"));
        headJson.put("functionCode", jsonObject.get((Object)"functionCode"));
        Map<String, String> headMap = this.getExcelHeadList(headJson, clientId, id);
        this.verificationHeadMap(headMap, id, clientId);
        Result result = this.getPageData(jsonObject, requestUrl, token, clientId, id);
        this.checkResult(result, id, clientId);
        JSONObject json1 = (JSONObject)JSON.toJSON((Object)result.getResult());
        Integer count = Integer.valueOf(json1.get((Object)"count").toString());
        this.verificationDataCount(count, id, clientId);
        this.sendWebSocketMessage(clientId, "\u5bfc\u51fa\u603b\u6761\u6570\uff1a" + count);
        Integer num = count / PAGE_SIZE;
        if (count % PAGE_SIZE > 0) {
            num = num + 2;
        }
        String a = json1.get((Object)"data").toString();
        JSONArray jsonArray = JSON.parseArray((String)a);
        ArrayList<Map> maps = new ArrayList<Map>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject j = jsonArray.getJSONObject(i);
            Map map = (Map)JSONObject.parseObject((String)j.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            maps.add(map);
        }
        ArrayList dataList = new ArrayList();
        for (Map data : maps) {
            ArrayList obj = new ArrayList();
            for (Map.Entry<String, String> map : headMap.entrySet()) {
                obj.add(data.get(map.getKey()));
            }
            dataList.add(obj);
        }
        String filePath = this.EXCEL_EXPORT_BASDIR + File.separator + excelFileName + ".xlsx";
        ExcelWriter excelWriter = null;
        try {
            List<List<String>> headList = this.head(headMap);
            excelWriter = ((ExcelWriterBuilder)EasyExcel.write((String)filePath).head(headList)).build();
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)sheetName).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
            Integer alreadyNum = dataList.size();
            this.againWrite(count, alreadyNum, dataList, writeSheet, excelWriter, clientId);
            this.againGetPageData(num, token, requestUrl, jsonObject, headMap, writeSheet, excelWriter, clientId, count, alreadyNum, id);
            this.sendWebSocketMessage(clientId, "\u5bfc\u51fa\u7ed3\u675f,\u603b\u5171\u5bfc\u51fa\u6570\u636e\uff1a" + count + "\u6761");
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
        this.sendWebSocketMessage(clientId, "\u5373\u5c06\u5b8c\u6210\u5bfc\u51fa\uff0c\u8bf7\u7a0d\u540e.......");
        String jsonResult = null;
        try {
            jsonResult = this.uploadFile(filePath, token, excelFileName);
        }
        catch (Exception e) {
            this.sendWebSocketMessage(clientId, "\u4e0a\u4f20\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25!");
            JSONObject requestParam = new JSONObject();
            requestParam.put("success", (Object)false);
            this.excelService.updateFailExcelFile(id, JSONObject.toJSONString((Object)requestParam));
        }
        return jsonResult;
    }

    private void againGetPageData(Integer num, String token, String requestUrl, JSONObject jsonObject, Map<String, String> headMap, WriteSheet writeSheet, ExcelWriter excelWriter, String clientId, Integer count, Integer alreadyNum, String id) {
        for (int i = 2; i < num; ++i) {
            jsonObject.put("pageNum", (Object)i);
            Result againResult = this.getPageData(jsonObject, requestUrl, token, clientId, id);
            JSONObject toJSON = (JSONObject)JSON.toJSON((Object)againResult.getResult());
            String str = toJSON.get((Object)"data").toString();
            JSONArray jsonArray = JSON.parseArray((String)str);
            ArrayList<Map> maps = new ArrayList<Map>();
            for (int j = 0; j < jsonArray.size(); ++j) {
                JSONObject job = jsonArray.getJSONObject(j);
                Map map = (Map)JSONObject.parseObject((String)job.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                maps.add(map);
            }
            ArrayList dataList = new ArrayList();
            for (Map data : maps) {
                ArrayList obj = new ArrayList();
                for (Map.Entry<String, String> map : headMap.entrySet()) {
                    obj.add(data.get(map.getKey()));
                }
                dataList.add(obj);
            }
            alreadyNum = alreadyNum + dataList.size();
            this.againWrite(count, alreadyNum, dataList, writeSheet, excelWriter, clientId);
        }
    }

    private Map<String, String> getExcelHeadList(JSONObject excelHeadRequest, String clientId, String id) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            MdmColumnConfigReqVo mdmColumnConfigReqVo = (MdmColumnConfigReqVo)excelHeadRequest.toJavaObject(MdmColumnConfigReqVo.class);
            Result result = this.mdmColumnConfigFeign.columnSelect(mdmColumnConfigReqVo);
            List mdmColumnExportRespVos = (List)new Gson().fromJson(new Gson().toJson(result.getResult()), new TypeToken<List<MdmColumnExportRespVo>>(){}.getType());
            mdmColumnExportRespVos = mdmColumnExportRespVos.stream().filter(data -> StringUtils.isNotEmpty((String)data.getField()) && StringUtils.isNotEmpty((String)data.getTitle())).collect(Collectors.toList());
            map = mdmColumnExportRespVos.stream().collect(Collectors.toMap(MdmColumnExportRespVo::getField, MdmColumnExportRespVo::getTitle));
        }
        catch (Exception e) {
            this.sendWebSocketMessage(clientId, "\u83b7\u53d6\u52a8\u6001\u5934\u90e8\u4fe1\u606f\u5931\u8d25!");
            JSONObject requestParam = new JSONObject();
            requestParam.put("success", (Object)false);
            this.excelService.updateFailExcelFile(id, JSONObject.toJSONString((Object)requestParam));
        }
        return map;
    }

    public String uploadFile(String urlFile, String token, String excelName) {
        String requestUrl = this.URL + this.UPLOAD_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set(LOGIN_FIELD, token);
        String[] fileUrls = urlFile.split(",");
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        for (int i = 0; i < fileUrls.length; ++i) {
            form.add((Object)"file", (Object)new FileSystemResource(fileUrls[i]));
        }
        HttpEntity httpEntity = new HttpEntity((Object)form, (MultiValueMap)headers);
        String result = RestTemplateUtils.postForObject(requestUrl, httpEntity);
        return result;
    }

    public String createExcelFile(String excelFileName, Class classObj, ExcelTypeEnum excelTypeEnum, List<?> data, Set<String> excludeColumnFiledNames) {
        if (null == classObj || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)excelFileName)) {
            throw new BusinessException("\u7c7b\u8def\u5f84\u3001\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == excelTypeEnum) {
            excelTypeEnum = ExcelTypeEnum.XLSX;
        }
        File file = ExcelImportUtil.writeFile(excelFileName, classObj, excelTypeEnum, data, excludeColumnFiledNames);
        return this.uploadFile(file.getPath(), UserUtils.getToken(), excelFileName);
    }

    private void verificationDataCount(Integer count, String id, String clientId) {
        if (count == 0) {
            this.sendWebSocketMessage(clientId, "\u5bfc\u51fa\u603b\u6761\u6570\u4e3a0,\u4e0d\u518d\u8fdb\u884c\u5bfc\u51fa");
            this.excelService.deleteUploadExcel(id);
            throw new BusinessException("\u5bfc\u51fa\u603b\u6761\u6570\u4e3a0,\u4e0d\u518d\u8fdb\u884c\u5bfc\u51fa");
        }
    }

    private void verificationHeadMap(Map<String, String> headMap, String id, String clientId) {
        if (headMap == null || headMap.size() <= 0) {
            this.sendWebSocketMessage(clientId, "\u672a\u8bbe\u7f6e\u52a8\u6001\u5bfc\u51fa\u5934\u90e8\u4fe1\u606f");
            this.excelService.deleteUploadExcel(id);
            throw new BusinessException("\u672a\u8bbe\u7f6e\u52a8\u6001\u5bfc\u51fa\u5934\u90e8\u4fe1\u606f");
        }
    }

    private void checkResult(Result result, String id, String clientId) {
        if (!result.isSuccess()) {
            this.sendWebSocketMessage(clientId, result.getMessage());
            this.excelService.deleteUploadExcel(id);
            throw new BusinessException(result.getMessage());
        }
    }

    private void sendWebSocketMessage(String clientId, String message) {
        userWebSocketHandler.sendMessageToUser(clientId, new TextMessage((CharSequence)JSONObject.toJSONString((Object)Result.ok((String)message))));
    }
}

