/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.controller;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.controller.resp.DemoFileResp;
import com.biz.crm.excel.service.ExcelImport;
import com.biz.crm.excel.util.ExcelExportUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"excelImportController"})
@Api(tags={"\u5bfc\u5165excel "})
public class ExcelImportController {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportController.class);
    @Resource(name="defaultExcelImport")
    private ExcelImport defaultExcelImport;
    @Resource
    private ExcelExportUtil excelExportUtil;

    @ApiOperation(value="\u5bfc\u5165excel")
    @PostMapping(value={"import"})
    @CrmLog
    public Result doImport(@ApiParam(value="\u5bfc\u5165\u914d\u7f6e\u7f16\u7801") @RequestParam(value="configCode") String configCode, @ApiParam(value="webSocket\u8fde\u63a5id") @RequestParam(value="webSocketClientId") String webSocketClientId, @RequestPart(value="file") MultipartFile file) {
        this.defaultExcelImport.doImport(webSocketClientId, configCode, UserUtils.getToken(), this.createTempFile(file));
        return Result.ok();
    }

    private File createTempFile(MultipartFile file) {
        if (null == file) {
            throw new BusinessException("\u8bf7\u4e0a\u4f20\u5bfc\u5165\u6587\u4ef6\uff01");
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            File fileTemp = File.createTempFile(file.getName() + UUIDGenerator.generate(), ExcelTypeEnum.XLSX.getValue());
            bis = new BufferedInputStream(file.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(fileTemp));
            int len = 0;
            byte[] buf = new byte[20480];
            while ((len = bis.read(buf)) != -1) {
                ((BufferedOutputStream)bos).write(buf, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            File file2 = fileTemp;
            return file2;
        }
        catch (IOException e) {
            log.warn("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            throw new BusinessException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                log.warn("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff01", (Throwable)e);
                throw new BusinessException("\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
            }
        }
    }

    @ApiOperation(value="\u5bfc\u5165excel,\u4e0b\u8f7d\u793a\u4f8b\u6587\u4ef6")
    @GetMapping(value={"demoFile"})
    @CrmLog
    public ResponseEntity<InputStreamResource> demoFile(@ApiParam(value="\u5bfc\u5165\u5bf9\u8c61\u7684\u7c7b\u8def\u5f84") @RequestParam String configCode) {
        DemoFileResp demoFileResp = this.defaultExcelImport.demoFile(configCode);
        String fileName = demoFileResp.getFileNameAsDemo() + ExcelTypeEnum.XLSX.getValue();
        if (!StringUtils.isEmpty((String)fileName)) {
            fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentDispositionFormData("attachment", fileName);
        httpHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        try {
            return new ResponseEntity((Object)new InputStreamResource((InputStream)new FileInputStream(demoFileResp.getFile())), (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        catch (FileNotFoundException e) {
            throw new BusinessException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }
}

