/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.upload.UploadEnum;
import com.biz.crm.excel.service.IExcelService;
import com.biz.crm.excel.util.ExcelExportUtil;
import com.biz.crm.mdm.tableconfig.MdmFunctionSubFeign;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.upload.excel.req.ExcelExportReqVo;
import com.biz.crm.upload.excel.ExcelExportFeign;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.TextMessage;

@Service
@ConditionalOnMissingBean(name={"ExcelServiceImpl"})
public class ExcelServiceImpl
implements IExcelService {
    private static final Logger log = LoggerFactory.getLogger(ExcelServiceImpl.class);
    private static final String LOGIN_FIELD = "loginUserToken";
    @Resource
    private ExcelExportUtil excelExportUtil;
    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();
    public static final DateTimeFormatter yyyyMMddHHmmss = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    @Value(value="${excel.export.url}")
    private String URL;
    @Value(value="${excel.export.downloadUrl}")
    private String EXCEL_DOWNLOAD_URL;
    @Resource
    private MdmFunctionSubFeign mdmFunctionSubFeign;
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Resource
    private ExcelExportFeign excelExportFeign;

    @Override
    public void checkWebSocketSession(final JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"sid")) {
            throw new BusinessException("websocket\u8fde\u63a5id\u4e3a\u7a7a");
        }
        if (!jsonObject.containsKey((Object)"parentCode") || !jsonObject.containsKey((Object)"functionCode")) {
            throw new BusinessException("\u7f3a\u5c11\u53c2\u6570\u4fe1\u606f:\u529f\u80fd\u7f16\u7801/\u83dc\u5355\u7f16\u7801");
        }
        if (!jsonObject.containsKey((Object)"requestUrl")) {
            throw new BusinessException("\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a");
        }
        RocketMQMessageBody body = new RocketMQMessageBody(){
            {
                this.setTag("WEBSOCKET_SESSION");
                this.setMsgBody(JSONObject.toJSONString((Object)jsonObject));
            }
        };
        this.rocketMQProducer.convertAndSend(body);
    }

    @Override
    public void repeatedWriteExport(JSONObject jsonObject) {
        LocalDateTime begin = LocalDateTime.now();
        String clientId = jsonObject.get((Object)"sid").toString();
        try {
            String token = UserUtils.getToken();
            AssertUtils.isNotEmpty((String)token, (String)"\u83b7\u53d6\u767b\u9646\u4eba\u4fe1\u606f\u4e3a\u7a7a");
            String id = this.saveExcelFile(jsonObject, clientId);
            String result = this.excelExportUtil.repeatedWrite(jsonObject, token, id);
            String data = this.updateExcelFile(id, result, begin);
            JSONObject resultData = JSONObject.parseObject((String)result);
            if (resultData.containsKey((Object)"result") && resultData.containsKey((Object)"success") && ((Boolean)resultData.get((Object)"success")).booleanValue()) {
                String objectName = this.getObjectName(result);
                JSONObject response = JSONObject.parseObject((String)data);
                if (response.containsKey((Object)"success") && ((Boolean)response.get((Object)"success")).booleanValue()) {
                    this.sendWebsocketMessage(clientId, "<a href=" + this.URL + this.EXCEL_DOWNLOAD_URL + "?objectName=" + objectName + ">\u70b9\u51fb\u4e0b\u8f7d</a>");
                }
            } else {
                this.sendWebsocketMessage(clientId, "\u66f4\u65b0excel\u6587\u4ef6\u5230\u4e0b\u8f7d\u4e2d\u5fc3\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.sendWebsocketMessage(clientId, "\u5bfc\u51faexcel\u6587\u4ef6\u5931\u8d25.....");
        }
    }

    private String saveExcelFile(JSONObject data, String clientId) {
        try {
            JSONObject requestParam = this.checkSaveParam(data, clientId);
            ExcelExportReqVo excelExportReqVo = (ExcelExportReqVo)requestParam.toJavaObject(ExcelExportReqVo.class);
            Result result = this.excelExportFeign.saveExcelFileBackId(excelExportReqVo);
            String id = (String)result.getResult();
            return id;
        }
        catch (Exception e) {
            this.sendWebsocketMessage(clientId, "\u4fdd\u5b58excel\u5230\u6587\u4ef6\u4e2d\u5fc3\u5931\u8d25");
            throw new BusinessException(e.getMessage());
        }
    }

    private JSONObject checkSaveParam(JSONObject requestParam, String clientId) {
        JSONObject jsonObject = new JSONObject();
        String functionName = this.getFunctionName(requestParam, clientId);
        String excelFileName = LocalDateTime.now().format(yyyyMMddHHmmss) + "_" + functionName;
        requestParam.put("excelFileName", (Object)excelFileName);
        requestParam.put("functionName", (Object)functionName);
        jsonObject.put("excelFileName", (Object)excelFileName);
        jsonObject.put("fileParam", (Object)JSONObject.toJSONString((Object)requestParam));
        jsonObject.put("fileSource", (Object)functionName);
        jsonObject.put("fileType", (Object)UploadEnum.fileType.EXPORT.getVal());
        jsonObject.put("fileStatus", (Object)UploadEnum.fileStatus.EXPORT_IN_EXECUTION.getVal());
        return jsonObject;
    }

    public String updateExcelFile(String id, String request, LocalDateTime begin) {
        JSONObject data = this.checkUpdateParam(request, id);
        ExcelExportReqVo excelExportReqVo = (ExcelExportReqVo)data.toJavaObject(ExcelExportReqVo.class);
        Duration duration = Duration.between(begin, LocalDateTime.now());
        String minutes = String.valueOf(duration.toMillis());
        excelExportReqVo.setTimeSpent(minutes);
        Result result = this.excelExportFeign.updateExcelFileById(excelExportReqVo);
        return JSONObject.toJSONString((Object)result);
    }

    public String updateFailExcelFile(String id, String request) {
        JSONObject data = this.checkUpdateParam(request, id);
        ExcelExportReqVo excelExportReqVo = (ExcelExportReqVo)data.toJavaObject(ExcelExportReqVo.class);
        Result result = this.excelExportFeign.updateExcelFileById(excelExportReqVo);
        return JSONObject.toJSONString((Object)result);
    }

    private String getFunctionName(JSONObject jsonObject, String clientId) {
        String functionName = null;
        final String parentCode = jsonObject.get((Object)"parentCode").toString();
        final String functionCode = jsonObject.get((Object)"functionCode").toString();
        MdmFunctionSubReqVo mdmFunctionSubReqVo = new MdmFunctionSubReqVo(){
            {
                this.setParentCode(parentCode);
                this.setFunctionCode(functionCode);
            }
        };
        try {
            Result mdmFunctionResult = this.mdmFunctionSubFeign.functionSubSearch(mdmFunctionSubReqVo);
            functionName = ((MdmFunctionSubRespVo)mdmFunctionResult.getResult()).getFunctionName();
        }
        catch (Exception e) {
            this.sendWebsocketMessage(clientId, "\u83b7\u53d6\u529f\u80fd\u540d\u79f0\u5931\u8d25");
        }
        return functionName;
    }

    private JSONObject checkUpdateParam(String request, String id) {
        JSONObject jsonObject = JSONObject.parseObject((String)request);
        JSONObject requestParam = new JSONObject();
        if (!(jsonObject.containsKey((Object)"result") && jsonObject.containsKey((Object)"success") && ((Boolean)jsonObject.get((Object)"success")).booleanValue())) {
            requestParam.put("fileStatus", (Object)UploadEnum.fileStatus.EXPORT_FAIL.getVal());
            requestParam.put("id", (Object)id);
        } else {
            String result = jsonObject.get((Object)"result").toString();
            JSONObject excelJsonObject = JSONObject.parseObject((String)JSONObject.parseArray((String)result).get(0).toString());
            requestParam.put("fileName", excelJsonObject.get((Object)"fileName"));
            requestParam.put("objectName", excelJsonObject.get((Object)"objectName"));
            requestParam.put("filePath", excelJsonObject.get((Object)"url"));
            requestParam.put("fileStatus", (Object)UploadEnum.fileStatus.EXPORT_SUCCESS.getVal());
            requestParam.put("id", (Object)id);
        }
        return requestParam;
    }

    private String getObjectName(String request) {
        JSONObject jsonObject = JSONObject.parseObject((String)request);
        String result = jsonObject.get((Object)"result").toString();
        JSONObject excelJsonObject = JSONObject.parseObject((String)JSONObject.parseArray((String)result).get(0).toString());
        String objectName = excelJsonObject.get((Object)"objectName").toString();
        return objectName;
    }

    public void deleteUploadExcel(final String id) {
        ExcelExportReqVo reqVo = new ExcelExportReqVo(){
            {
                this.setIds(Lists.newArrayList((Object[])new String[]{id}));
            }
        };
        this.excelExportFeign.delete(reqVo);
    }

    private void sendWebsocketMessage(String clientId, String message) {
        userWebSocketHandler.sendMessageToUser(clientId, new TextMessage((CharSequence)JSONObject.toJSONString((Object)Result.ok((String)message))));
    }
}

