/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.websocket.user.endpoint;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class UserWebSocketHandler
implements WebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(UserWebSocketHandler.class);
    private static final Map<String, WebSocketSession> users = new HashMap<String, WebSocketSession>();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        log.info("\u8fde\u63a5websoct\u6210\u529f!");
        String ID = session.getAttributes().get("WEBSOCKET_USERID").toString();
        log.info(ID);
        if (ID != null) {
            users.put(ID, session);
            log.info("id:" + ID + ",session:" + session + "");
        }
        log.info("current user number is:" + users.size());
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        try {
            JSONObject jsonobject = JSONObject.parseObject((String)((String)message.getPayload()));
            log.info("websoct \u63a5\u6536\u5230\u6d88\u606f:" + jsonobject);
        }
        catch (Exception e) {
            log.error("e", (Throwable)e);
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        if (session.isOpen()) {
            session.close();
        }
        log.error("websoct \u8fde\u63a5\u5f02\u5e38", exception);
        users.remove(this.getClientId(session));
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        log.error("websoct \u8fde\u63a5\u88ab\u5173\u95ed" + closeStatus);
        users.remove(this.getClientId(session));
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    public boolean sendMessageToUser(String clientId, TextMessage message) {
        if (users.get(clientId) == null) {
            return false;
        }
        WebSocketSession session = users.get(clientId);
        log.info("websoct \u7ed9\u7528\u6237\u53d1\u9001\u6d88\u606f:" + message);
        if (!session.isOpen()) {
            return false;
        }
        try {
            session.sendMessage((WebSocketMessage)message);
        }
        catch (IOException e) {
            log.error("e", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean sendMessageToAllUsers(TextMessage message) {
        boolean allSendSuccess = true;
        Set<String> clientIds = users.keySet();
        WebSocketSession session = null;
        for (String clientId : clientIds) {
            try {
                session = users.get(clientId);
                if (!session.isOpen()) continue;
                session.sendMessage((WebSocketMessage)message);
            }
            catch (IOException e) {
                log.error("e", (Throwable)e);
                allSendSuccess = false;
            }
        }
        return allSendSuccess;
    }

    private String getClientId(WebSocketSession session) {
        try {
            String clientId = (String)session.getAttributes().get("WEBSOCKET_USERID");
            return clientId;
        }
        catch (Exception e) {
            log.error("e", (Throwable)e);
            return null;
        }
    }

    public synchronized int getOnlineNum() {
        return users.size();
    }

    public Boolean getWebSocketSession(String clientId) {
        Boolean flag = false;
        WebSocketSession session = users.get(clientId);
        if (session != null && session.isOpen()) {
            flag = true;
        }
        return flag;
    }
}

