/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.config.OperatorInterceptor;
import com.biz.crm.data.ExcelDruidParam;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.biz.crm.excel.**.mapper*"}, sqlSessionTemplateRef="excelSqlSessionTemplate")
public class ExcelDruidConfig {
    private static final Logger log = LoggerFactory.getLogger(ExcelDruidConfig.class);
    @Resource
    private ExcelDruidParam excelDruidParam;

    @Bean(value={"excelDataSource"})
    public DataSource excelDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.excelDruidParam.getDbUrl());
        datasource.setUsername(this.excelDruidParam.getUsername());
        datasource.setPassword(this.excelDruidParam.getPassword());
        datasource.setDriverClassName(this.excelDruidParam.getDriverClassName());
        datasource.setInitialSize(this.excelDruidParam.getInitialSize());
        datasource.setMinIdle(this.excelDruidParam.getMinIdle());
        datasource.setMaxActive(this.excelDruidParam.getMaxActive());
        datasource.setMaxWait((long)this.excelDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis((long)this.excelDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis((long)this.excelDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis((long)this.excelDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(this.excelDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(this.excelDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(this.excelDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(this.excelDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(this.excelDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.excelDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(this.excelDruidParam.getFilters());
        }
        catch (Exception e) {
            log.error("druid configuration initialization filter", (Throwable)e);
        }
        datasource.setConnectionProperties(this.excelDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    @Primary
    public SqlSessionFactory excelSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(this.excelDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/excel/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }

    @Bean(name={"excelTransactionManager"})
    public DataSourceTransactionManager excelTransactionManager() {
        return new DataSourceTransactionManager(this.excelDataSource());
    }

    @Bean(name={"excelSqlSessionTemplate"})
    public SqlSessionTemplate excelSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.excelSqlSessionFactory());
    }
}

