/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.biz.crm.config.OperatorInterceptor;
import com.biz.crm.data.MdmDruidParam;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(value={"com.biz.crm.mdm.**.mapper*"}, sqlSessionTemplateRef="mdmSqlSessionTemplate")
public class MdmDruidConfig {
    private static final Logger log = LoggerFactory.getLogger(MdmDruidConfig.class);
    @Resource
    private MdmDruidParam mdmDruidParam;

    @Bean(value={"mdmDataSource"})
    public DataSource mdmDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.mdmDruidParam.getDbUrl());
        datasource.setUsername(this.mdmDruidParam.getUsername());
        datasource.setPassword(this.mdmDruidParam.getPassword());
        datasource.setDriverClassName(this.mdmDruidParam.getDriverClassName());
        datasource.setInitialSize(this.mdmDruidParam.getInitialSize());
        datasource.setMinIdle(this.mdmDruidParam.getMinIdle());
        datasource.setMaxActive(this.mdmDruidParam.getMaxActive());
        datasource.setMaxWait((long)this.mdmDruidParam.getMaxWait());
        datasource.setTimeBetweenEvictionRunsMillis((long)this.mdmDruidParam.getTimeBetweenEvictionRunsMillis());
        datasource.setMinEvictableIdleTimeMillis((long)this.mdmDruidParam.getMinEvictableIdleTimeMillis());
        datasource.setMaxEvictableIdleTimeMillis((long)this.mdmDruidParam.getMaxEvictableIdleTimeMillis());
        datasource.setValidationQuery(this.mdmDruidParam.getValidationQuery());
        datasource.setTestWhileIdle(this.mdmDruidParam.isTestWhileIdle());
        datasource.setTestOnBorrow(this.mdmDruidParam.isTestOnBorrow());
        datasource.setTestOnReturn(this.mdmDruidParam.isTestOnReturn());
        datasource.setPoolPreparedStatements(this.mdmDruidParam.isPoolPreparedStatements());
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.mdmDruidParam.getMaxPoolPreparedStatementPerConnectionSize());
        try {
            datasource.setFilters(this.mdmDruidParam.getFilters());
        }
        catch (Exception e) {
            log.error("druid configuration initialization filter", (Throwable)e);
        }
        datasource.setConnectionProperties(this.mdmDruidParam.getConnectionProperties());
        return datasource;
    }

    @Bean
    public SqlSessionFactory mdmSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        factory.setDataSource(this.mdmDataSource());
        factory.setMapperLocations(resolver.getResources("classpath*:/mapper/mdm/**/*.xml"));
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new OperatorInterceptor());
        factory.setGlobalConfig(globalConfig);
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setCacheEnabled(false);
        factory.setConfiguration(configuration);
        return factory.getObject();
    }

    @Bean(name={"mdmTransactionManager"})
    @Primary
    public DataSourceTransactionManager mdmTransactionManager() {
        return new DataSourceTransactionManager(this.mdmDataSource());
    }

    @Primary
    @Bean(name={"mdmSqlSessionTemplate"})
    public SqlSessionTemplate mdmSqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.mdmSqlSessionFactory());
    }
}

