/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.customer;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.customer.MdmCustomerImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerContactMapper;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmCustomerImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmCustomerImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmCustomerMsgMapper, MdmCustomerEntity, MdmCustomerImportVo>
implements ExcelImportSaver<MdmCustomerImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerImportSaver.class);
    @Resource
    private MdmCustomerContactMapper mdmCustomerContactMapper;

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="mdmTransactionManager")
    public void save(List<MdmCustomerImportVo> data, DefaultImportContext context) {
        if (!CollectionUtils.isEmpty(data)) {
            this.saveContact(data);
            List partition = Lists.partition(data, (int)50);
            for (List mdmCustomerImportVos : partition) {
                List entityList = CrmBeanUtil.copyList((List)mdmCustomerImportVos, MdmCustomerEntity.class);
                for (MdmCustomerEntity mdmCustomerEntity : entityList) {
                    String userName = mdmCustomerEntity.getUserName();
                    if (StringUtils.isEmpty((Object)userName)) continue;
                    mdmCustomerEntity.setCustomerPrimary(YesNoEnum.yesNoEnum.ONE.getValue());
                }
                this.saveBatch(entityList);
            }
        }
    }

    protected void saveContact(List<MdmCustomerImportVo> data) {
        List<MdmCustomerContactEntity> mdmCustomerContactEntities = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getContactName()) || !StringUtils.isEmpty((Object)x.getContactPhone())).map(x -> {
            MdmCustomerContactEntity mdmCustomerContactEntity = new MdmCustomerContactEntity();
            mdmCustomerContactEntity.setId(UUID.randomUUID().toString());
            mdmCustomerContactEntity.setCustomerCode(x.getCustomerCode());
            mdmCustomerContactEntity.setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
            mdmCustomerContactEntity.setContactName(x.getContactName());
            mdmCustomerContactEntity.setContactPhone(x.getContactPhone());
            return mdmCustomerContactEntity;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mdmCustomerContactEntities)) {
            this.mdmCustomerContactMapper.insertBatch(mdmCustomerContactEntities);
        }
    }
}

