/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.customerorg;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.customerorg.MdmCustomerOrgImportVo;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmCustomerOrgImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmCustomerOrgImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmCusOrgMapper, MdmCusOrgEntity, MdmCustomerOrgImportVo>
implements ExcelImportSaver<MdmCustomerOrgImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerOrgImportSaver.class);
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    @Override
    public void save(List<MdmCustomerOrgImportVo> data, DefaultImportContext context) {
        log.info("\u7ec4\u7ec7\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            ArrayList<MdmCusOrgEntity> entityList = new ArrayList<MdmCusOrgEntity>();
            for (MdmCustomerOrgImportVo item : data) {
                if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
                MdmCusOrgEntity copy = (MdmCusOrgEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmCusOrgEntity.class));
                if (StringUtils.isEmpty((String)copy.getCustomerOrgCode())) {
                    copy.setCustomerOrgCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_CUSTOMER_ORG.getCode()));
                }
                copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                copy.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                copy.setLevelNum(1);
                entityList.add(copy);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List partition = Lists.partition(entityList, (int)50);
                for (List item : partition) {
                    this.saveBatch(item);
                }
                this.resetRuleCode();
            }
        }
    }

    private void resetRuleCode() {
        this.mdmCusOrgMapper.copyIdToRuleCode();
        this.mdmCusOrgMapper.setNullNotExistParentCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmCusOrgEntity::getParentCode)).or()).eq(MdmCusOrgEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < list.size(); ++i) {
            this.updateCurAndChildren(((MdmCusOrgEntity)((Object)list.get(i))).getCustomerOrgCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
        }
    }

    private void updateCurAndChildren(String orgCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)orgCode)).set(CrmTreeEntity::getRuleCode, (Object)curCode)).set(CrmTreeEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getParentCode, (Object)orgCode)).select(new SFunction[]{MdmCusOrgEntity::getCustomerOrgCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmCusOrgEntity)((Object)list.get(i))).getCustomerOrgCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }
}

