/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.material;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.material.MdmMaterialImportVo;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmMaterialImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmMaterialImportSaver<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmMaterialMapper, MdmMaterialEntity>
implements ExcelImportSaver<MdmMaterialImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialImportSaver.class);

    @Override
    public void save(List<MdmMaterialImportVo> data, DefaultImportContext context) {
        log.info("\u7269\u6599\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            List materials = Lists.partition(data, (int)50);
            for (List material : materials) {
                List entityList = CrmBeanUtil.copyList((List)material, MdmMaterialEntity.class);
                this.saveBatch(entityList);
            }
        }
    }
}

