/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.org;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.org.MdmOrgImportVo;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmOrgImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmOrgImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmOrgMapper, MdmOrgEntity, MdmOrgImportVo>
implements ExcelImportSaver<MdmOrgImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgImportSaver.class);
    @Resource
    private MdmOrgMapper mdmOrgMapper;

    @Override
    public void save(List<MdmOrgImportVo> data, DefaultImportContext context) {
        log.info("\u7ec4\u7ec7\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            ArrayList<MdmOrgEntity> entityList = new ArrayList<MdmOrgEntity>();
            for (MdmOrgImportVo item : data) {
                if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
                MdmOrgEntity copy = (MdmOrgEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmOrgEntity.class));
                if (StringUtils.isEmpty((String)copy.getOrgCode())) {
                    copy.setOrgCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ORG_CODE.getCode()));
                }
                copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                copy.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                copy.setLevelNum(1);
                entityList.add(copy);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List partition = Lists.partition(entityList, (int)50);
                for (List item : partition) {
                    this.saveBatch(item);
                }
                this.resetRuleCode();
                OrgUtil.deleteAllCache();
            }
        }
    }

    private void resetRuleCode() {
        this.mdmOrgMapper.copyIdToRuleCode();
        this.mdmOrgMapper.setNullNotExistParentCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmOrgEntity::getParentCode)).or()).eq(MdmOrgEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < list.size(); ++i) {
            this.updateCurAndChildren(((MdmOrgEntity)((Object)list.get(i))).getOrgCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
        }
    }

    private void updateCurAndChildren(String orgCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmOrgEntity::getOrgCode, (Object)orgCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)orgCode)).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmOrgEntity)((Object)list.get(i))).getOrgCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }
}

