/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.position;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.position.MdmPositionImportVo;
import com.biz.crm.mdm.position.entity.MdmPositionBpmRoleEntity;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.entity.MdmPositionRoleEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionBpmRoleMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionRoleMapper;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component(value="mdmPositionImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmPositionImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmPositionMapper, MdmPositionEntity, MdmPositionImportVo>
implements ExcelImportSaver<MdmPositionImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionImportSaver.class);
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmPositionRoleMapper mdmPositionRoleMapper;
    @Resource
    private MdmPositionBpmRoleMapper mdmPositionBpmRoleMapper;

    @Override
    public void save(List<MdmPositionImportVo> data, DefaultImportContext context) {
        log.info("\u804c\u4f4d\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            ArrayList<MdmPositionEntity> entityList = new ArrayList<MdmPositionEntity>();
            ArrayList positionBpmRoleEntityList = new ArrayList();
            ArrayList positionRoleEntityList = new ArrayList();
            for (MdmPositionImportVo item : data) {
                if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
                MdmPositionEntity copy = (MdmPositionEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmPositionEntity.class));
                copy.setPositionCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_CODE.getCode()));
                copy.setPositionName(this.generatePositionNameByPositionLevelCode(item.getPositionLevelCode()));
                copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                copy.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                copy.setRuleCode(UUID.randomUUID().toString().replace("-", ""));
                copy.setLevelNum(1);
                entityList.add(copy);
                if (StringUtils.isNotEmpty((String)item.getRoleCode())) {
                    positionRoleEntityList.addAll(Arrays.stream(item.getRoleCode().split(",")).map(x -> {
                        MdmPositionRoleEntity positionRoleEntity = new MdmPositionRoleEntity();
                        positionRoleEntity.setPositionCode(copy.getPositionCode());
                        positionRoleEntity.setRoleCode((String)x);
                        return positionRoleEntity;
                    }).collect(Collectors.toList()));
                }
                if (!StringUtils.isNotEmpty((String)item.getBpmRoleCode())) continue;
                positionBpmRoleEntityList.addAll(Arrays.stream(item.getBpmRoleCode().split(",")).map(x -> {
                    MdmPositionBpmRoleEntity positionRoleEntity = new MdmPositionBpmRoleEntity();
                    positionRoleEntity.setPositionCode(copy.getPositionCode());
                    positionRoleEntity.setBpmRoleCode((String)x);
                    return positionRoleEntity;
                }).collect(Collectors.toList()));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List partition = Lists.partition(entityList, (int)50);
                for (Object item : partition) {
                    this.saveBatch((Collection)item);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(positionRoleEntityList)) {
                    for (Object item : positionRoleEntityList) {
                        this.mdmPositionRoleMapper.insert(item);
                    }
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(positionBpmRoleEntityList)) {
                    for (Object item : positionBpmRoleEntityList) {
                        this.mdmPositionBpmRoleMapper.insert(item);
                    }
                }
                this.resetRuleCode();
                PositionUtil.deleteAllCache();
            }
        }
    }

    private void resetRuleCode() {
        this.mdmPositionMapper.copyIdToRuleCode();
        this.mdmPositionMapper.setNullNotExistParentCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        wrapper.and(x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"parent_code", (Object)"")).or()).isNull((Object)"parent_code");
        });
        List list = this.mdmPositionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
            }
        }
    }

    private void updateCurAndChildren(String positionCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)positionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }

    public String generatePositionNameByPositionLevelCode(String positionLevelCode) {
        Assert.hasText((String)positionLevelCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"position_level_code", (Object)positionLevelCode);
        MdmPositionLevelEntity positionLevel = (MdmPositionLevelEntity)((Object)this.mdmPositionLevelMapper.selectOne((Wrapper)wrapper));
        Assert.notNull((Object)((Object)positionLevel), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7ea7\u522b");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(positionLevel.getEnableStatus()), (String)"\u8be5\u804c\u4f4d\u7ea7\u522b\u5df2\u505c\u7528");
        Integer suffixSequence = positionLevel.getSuffixSequence();
        if (suffixSequence == null) {
            suffixSequence = 0;
        }
        HashSet positionNameSet = new HashSet(16);
        List positionList = ((LambdaQueryChainWrapper)this.lambdaQuery().like(MdmPositionEntity::getPositionName, (Object)positionLevel.getPositionLevelName())).select(new SFunction[]{MdmPositionEntity::getPositionName}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionList)) {
            positionNameSet.addAll(positionList.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.toSet()));
        }
        suffixSequence = suffixSequence + 1;
        String positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
        while (!positionNameSet.isEmpty() && positionNameSet.contains(positionName)) {
            suffixSequence = suffixSequence + 1;
            positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
        }
        LambdaUpdateWrapper positionLevelUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)positionLevelUpdateWrapper.eq(MdmPositionLevelEntity::getPositionLevelCode, (Object)positionLevelCode)).set(MdmPositionLevelEntity::getSuffixSequence, (Object)suffixSequence);
        this.mdmPositionLevelMapper.update(null, (Wrapper)positionLevelUpdateWrapper);
        return positionName;
    }
}

