/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.positionlevel;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.component.saver.mdm.positionlevel.MdmPositionLevelRoleImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.positionlevel.MdmPositionLevelImportVo;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelRoleEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="mdmPositionLevelImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmPositionLevelImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmPositionLevelMapper, MdmPositionLevelEntity, MdmPositionLevelImportVo>
implements ExcelImportSaver<MdmPositionLevelImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionLevelImportSaver.class);
    @Resource(name="mdmPositionLevelRoleImportSaver")
    private MdmPositionLevelRoleImportSaver mdmPositionLevelRoleImportSaver;

    @Override
    public void save(List<MdmPositionLevelImportVo> data, DefaultImportContext context) {
        log.info("\u6570\u636e\u4fdd\u5b58:{}", data);
        ArrayList<MdmPositionLevelRoleEntity> roleEntityList = new ArrayList<MdmPositionLevelRoleEntity>();
        ArrayList<MdmPositionLevelImportVo> list = new ArrayList<MdmPositionLevelImportVo>();
        for (int i = 0; i < data.size(); ++i) {
            if (data.get(i).getProcessType() != AbstractImportVo.ProcessTypeEnum.SUCCESS) continue;
            List<String> roleCode = Arrays.asList(data.get(i).getRoleCode().split(","));
            for (int x = 0; x < roleCode.size(); ++x) {
                MdmPositionLevelRoleEntity roleEntity = new MdmPositionLevelRoleEntity();
                roleEntity.setPositionLevelCode(data.get(i).getPositionLevelCode());
                roleEntity.setRoleCode(roleCode.get(x));
                roleEntityList.add(roleEntity);
            }
            list.add(data.get(i));
        }
        this.saveBatch(CrmBeanUtil.copyList(list, MdmPositionLevelEntity.class));
        this.mdmPositionLevelRoleImportSaver.save(roleEntityList);
    }
}

