/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.product;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.component.saver.mdm.product.MdmProductMaterialImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.product.MdmProductImportVo;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.entity.MdmProductMaterialEntity;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmProductImportSaver")
public class MdmProductImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmProductMapper, MdmProductEntity, MdmProductImportVo>
implements ExcelImportSaver<MdmProductImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmProductImportSaver.class);

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="mdmTransactionManager")
    public void save(List<MdmProductImportVo> data, DefaultImportContext context) {
        log.info("\u5546\u54c1\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            List partition = Lists.partition(data, (int)50);
            for (List mdmProductImportVos : partition) {
                List entityList = CrmBeanUtil.copyList((List)mdmProductImportVos, MdmProductEntity.class);
                entityList.stream().forEach(m -> {
                    if (StringUtils.isNotEmpty((String)m.getBeginDate())) {
                        m.setBeginDateSecond("00:00:00");
                    }
                    if (StringUtils.isNotEmpty((String)m.getEndDate())) {
                        m.setEndDateSecond("23:59:59");
                    }
                });
                this.saveBatch(entityList);
                ArrayList materialEntities = new ArrayList();
                mdmProductImportVos.stream().filter(m -> StringUtils.isNotEmpty((String)m.getMaterialCode())).forEach(m -> {
                    MdmProductMaterialEntity copy = (MdmProductMaterialEntity)((Object)((Object)CrmBeanUtil.copy((Object)m, MdmProductMaterialEntity.class)));
                    if (!Objects.isNull(m.getCount())) {
                        copy.setCount(Integer.valueOf(m.getCount()));
                    }
                    materialEntities.add(copy);
                });
                MdmProductMaterialImportSaver mdmProductMaterialImportSaver = new MdmProductMaterialImportSaver();
                if (!CollectionUtil.listNotEmptyNotSizeZero(materialEntities)) continue;
                mdmProductMaterialImportSaver.saveBatch(materialEntities);
            }
        }
    }
}

