/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.product;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.product.MdmProductLevelImportVo;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="mdmProductLevelImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmProductLevelImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmProductLevelMapper, MdmProductLevelEntity, MdmProductLevelImportVo>
implements ExcelImportSaver<MdmProductLevelImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelImportSaver.class);
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;

    @Override
    public void save(List<MdmProductLevelImportVo> data, DefaultImportContext context) {
        log.info("\u4ea7\u54c1\u5c42\u7ea7\u5bfc\u5165:{}", data);
        if (!data.isEmpty()) {
            List productLevel = Lists.partition(data, (int)50);
            for (List mdmProductLevelImportVos : productLevel) {
                List levelEntities = CrmBeanUtil.copyList((List)mdmProductLevelImportVos, MdmProductLevelEntity.class);
                levelEntities.stream().filter(m -> StringUtils.isNotEmpty((String)m.getProductLevelName()) && StringUtils.isNotEmpty((String)m.getProductLevelCode())).forEach(m -> {
                    m.setRuleCode("");
                    m.setLevelNum(1);
                });
                this.saveBatch(levelEntities);
            }
            this.resetRuleCode();
        }
    }

    private void resetRuleCode() {
        this.mdmProductLevelMapper.copyIdToRuleCode();
        this.mdmProductLevelMapper.setNullNotExistParentCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        wrapper.and(x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"parent_code", (Object)"")).or()).isNull((Object)"parent_code");
        });
        List list = this.mdmProductLevelMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmProductLevelEntity)((Object)list.get(i))).getProductLevelCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
            }
        }
    }

    private void updateCurAndChildren(String productLevelCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).set(CrmTreeEntity::getRuleCode, (Object)curCode)).set(CrmTreeEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentCode, (Object)productLevelCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmProductLevelEntity)((Object)list.get(i))).getProductLevelCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }
}

