/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.role;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.role.MdmRoleImportVo;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="mdmRoleImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmRoleImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmRoleMapper, MdmRoleEntity, MdmRoleImportVo>
implements ExcelImportSaver<MdmRoleImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleImportSaver.class);

    @Override
    public void save(List<MdmRoleImportVo> data, DefaultImportContext context) {
        log.info("\u89d2\u8272\u5bfc\u5165:{}", data);
        if (!CollectionUtils.isEmpty(data)) {
            ArrayList<MdmRoleEntity> entityList = new ArrayList<MdmRoleEntity>();
            for (MdmRoleImportVo item : data) {
                if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
                MdmRoleEntity copy = (MdmRoleEntity)((Object)CrmBeanUtil.copy((Object)((Object)item), MdmRoleEntity.class));
                if (StringUtils.isEmpty((String)copy.getRoleCode())) {
                    copy.setRoleCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ROLE_CODE.getCode()));
                }
                copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                entityList.add(copy);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                List partition = Lists.partition(entityList, (int)50);
                for (List item : partition) {
                    this.saveBatch(item);
                }
            }
        }
    }
}

