/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.mdm.user;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmCustomerUserImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.role.entity.MdmRoleCustomerEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleCustomerMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="mdmCustomerUserImportSaver")
@Transactional(value="mdmTransactionManager")
public class MdmCustomerUserImportSaver<M extends BaseMapper<T>, T>
extends AbstractExcelImportSaver<MdmUserMapper, MdmUserEntity, MdmCustomerUserImportVo>
implements ExcelImportSaver<MdmCustomerUserImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerUserImportSaver.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmRoleCustomerMapper mdmRoleCustomerMapper;

    @Override
    public void save(List<MdmCustomerUserImportVo> data, DefaultImportContext context) {
        log.info("\u5bfc\u5165\u7528\u6237");
        if (data == null || data.size() == 0) {
            return;
        }
        ArrayList<MdmUserEntity> userEntityList = new ArrayList<MdmUserEntity>();
        ArrayList<MdmRoleCustomerEntity> roleCustomerEntityList = new ArrayList<MdmRoleCustomerEntity>();
        HashMap<String, String> customerUserMap = new HashMap<String, String>(16);
        for (Object item : data) {
            if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item.getProcessType()) continue;
            MdmUserEntity copy = (MdmUserEntity)((Object)CrmBeanUtil.copy((Object)item, MdmUserEntity.class));
            copy.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            copy.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)item.getUserPassword()));
            copy.setUserType(UserTypeEnum.CUSTOMER.getCode());
            copy.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
            userEntityList.add(copy);
            customerUserMap.put(item.getCustomerCode(), item.getUserName());
            if (!StringUtils.isNotEmpty((String)item.getRoleCode())) continue;
            MdmRoleCustomerEntity roleCustomer = new MdmRoleCustomerEntity();
            roleCustomer.setCustomerCode(item.getCustomerCode());
            roleCustomer.setRoleCode(item.getRoleCode());
            roleCustomerEntityList.add(roleCustomer);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(userEntityList)) {
            List userGroup = Lists.partition(userEntityList, (int)50);
            for (Object item : userGroup) {
                this.saveBatch((Collection)item);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(roleCustomerEntityList)) {
                LambdaUpdateWrapper customerRoleDelete = new LambdaUpdateWrapper();
                customerRoleDelete.in(MdmRoleCustomerEntity::getCustomerCode, (Collection)roleCustomerEntityList.stream().map(MdmRoleCustomerEntity::getCustomerCode).collect(Collectors.toSet()));
                this.mdmRoleCustomerMapper.delete((Wrapper)customerRoleDelete);
                for (MdmRoleCustomerEntity item : roleCustomerEntityList) {
                    this.mdmRoleCustomerMapper.insert((Object)item);
                }
            }
            for (Map.Entry entry : customerUserMap.entrySet()) {
                LambdaUpdateWrapper customerUpdate = new LambdaUpdateWrapper();
                customerUpdate.eq(MdmCustomerEntity::getCustomerCode, entry.getKey());
                customerUpdate.set(MdmCustomerEntity::getCustomerPrimary, (Object)YesNoEnum.yesNoEnum.ZERO.getValue());
                customerUpdate.set(MdmCustomerEntity::getUserName, entry.getValue());
                this.mdmCustomerMsgMapper.update(null, (Wrapper)customerUpdate);
            }
        }
    }
}

