/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.saver.sfa;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.excel.component.saver.AbstractExcelImportSaver;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.TestImportVo;
import com.biz.crm.excel.vo.sfa.calculateSalaryDate.SfaCalculateSalaryDateImportVo;
import com.biz.crm.sfa.calculateSalaryDate.entity.SfaCalculateSalaryDateEntity;
import com.biz.crm.sfa.calculateSalaryDate.mapper.SfaCalculateSalaryDateMapper;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="sfaCalculateSalaryDateImportSaver")
public class SfaCalculateSalaryDateImportSaver<M extends BaseMapper<T>, T, ImportVo extends TestImportVo>
extends AbstractExcelImportSaver<SfaCalculateSalaryDateMapper, SfaCalculateSalaryDateEntity, SfaCalculateSalaryDateImportVo>
implements ExcelImportSaver<SfaCalculateSalaryDateImportVo> {
    private static final Logger log = LoggerFactory.getLogger(SfaCalculateSalaryDateImportSaver.class);

    @Override
    public void save(List<SfaCalculateSalaryDateImportVo> data, DefaultImportContext context) {
        UserRedis userRedis = UserUtils.getUser();
        List partitionDataList = Lists.partition(data, (int)50);
        partitionDataList.forEach(dataList -> {
            List sfaCalculateSalaryDateEntities = CrmBeanUtil.copyList((List)dataList, SfaCalculateSalaryDateEntity.class);
            String createDateSecond = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss).split(" ")[1];
            sfaCalculateSalaryDateEntities.forEach(da -> {
                da.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                da.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                da.setCreateOrgCode(userRedis.getOrgcode());
                da.setCreateOrgName(userRedis.getOrgname());
                da.setCreatePosCode(userRedis.getPoscode());
                da.setCreatePosName(userRedis.getPosname());
                da.setCreateCode(userRedis.getUsername());
                da.setCreateName(userRedis.getRealname());
                da.setUserName(userRedis.getUsername());
                da.setRealName(userRedis.getRealname());
                da.setOrgCode(userRedis.getOrgcode());
                da.setOrgName(userRedis.getOrgname());
                da.setPosCode(userRedis.getPoscode());
                da.setPosName(userRedis.getPosname());
                da.setCreateDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
                da.setCreateDateSecond(createDateSecond);
            });
            this.saveBatch(sfaCalculateSalaryDateEntities);
        });
    }
}

