/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.customer;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.customer.MdmCustomerImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmCustomerImportValidator")
public class MdmCustomerImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmCustomerMsgMapper, MdmCustomerEntity, MdmCustomerImportVo>
implements ExcelImportValidator<MdmCustomerImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerImportValidator.class);
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;
    @Resource
    private MdmUserMapper mdmUserMapper;

    @Override
    public void validate(List<MdmCustomerImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.initialsCustomerCode(data);
        this.validCustomerCode(data);
        this.validCustomerName(data);
        this.validChannel(data);
        this.validCustomerType(data);
        this.validOrgCode(data);
        this.validCustomerOrgCode(data);
    }

    protected void validCustomerOrgCode(List<MdmCustomerImportVo> data) {
        long count = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getCustomerOrgCode())).count();
        if (count < 1L) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmCusOrgEntity::getCustomerOrgCode});
        Set dbCustomerOrgSet = this.mdmCusOrgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getCustomerOrgCode())).map(MdmCusOrgEntity::getCustomerOrgCode).collect(Collectors.toSet());
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String customerOrgCode = mdmCustomerImportVo.getCustomerOrgCode();
            if (StringUtils.isEmpty((Object)customerOrgCode) || !CollectionUtils.isEmpty(dbCustomerOrgSet) && dbCustomerOrgSet.contains(customerOrgCode)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801" + customerOrgCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validOrgCode(List<MdmCustomerImportVo> data) {
        long count = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getOrgCode())).count();
        if (count < 1L) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmOrgEntity::getOrgCode});
        Set dbOrgCodeSet = this.mdmOrgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getOrgCode())).map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet());
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String orgCode = mdmCustomerImportVo.getOrgCode();
            if (StringUtils.isEmpty((Object)orgCode)) {
                mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u7ec4\u7ec7\u7f16\u7801\u672a\u586b\u5199;");
                continue;
            }
            if (orgCode.contains(",")) {
                String[] orgCodeList;
                for (String splitOrgCode : orgCodeList = orgCode.split(",")) {
                    if (!CollectionUtils.isEmpty(dbOrgCodeSet) && dbOrgCodeSet.contains(splitOrgCode)) continue;
                    mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u7ec4\u7ec7\u7f16\u7801" + splitOrgCode + "\u4e0d\u5b58\u5728;");
                }
                continue;
            }
            if (!CollectionUtils.isEmpty(dbOrgCodeSet) && dbOrgCodeSet.contains(orgCode)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u7ec4\u7ec7\u7f16\u7801" + orgCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCustomerType(List<MdmCustomerImportVo> data) {
        Map customerTypeMap = DictUtil.dictMap((String)"customer_type");
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String customerType = mdmCustomerImportVo.getCustomerType();
            if (StringUtils.isEmpty((Object)customerType)) {
                mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u7c7b\u578b\u672a\u586b\u5199;");
                continue;
            }
            if (customerTypeMap != null && customerTypeMap.containsKey(customerType)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u7c7b\u578b" + customerType + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validChannel(List<MdmCustomerImportVo> data) {
        Map map = DictUtil.dictMap((String)"channel");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String channel = mdmCustomerImportVo.getChannel();
            if (StringUtils.isEmpty((Object)channel)) {
                mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u6e20\u9053\u672a\u586b\u5199;");
                continue;
            }
            if (channelMap != null && channelMap.containsKey(channel)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u6e20\u9053" + channel + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCustomerName(List<MdmCustomerImportVo> data) {
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmCustomerImportVo.getCustomerName())) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
    }

    protected void validCustomerCode(List<MdmCustomerImportVo> data) {
        for (Object mdmCustomerImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmCustomerImportVo.getCustomerCode())) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        HashSet<String> repeatCustomerCodeSet = new HashSet<String>(data.size());
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String customerCode = mdmCustomerImportVo.getCustomerCode();
            if (StringUtils.isEmpty((Object)customerCode) || repeatCustomerCodeSet.add(customerCode)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u7f16\u7801" + customerCode + "\u5df2\u91cd\u590d;");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmCustomerEntity::getCustomerCode});
        Set dbCustomerCodeSet = this.mdmCustomerMsgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getCustomerCode())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(dbCustomerCodeSet)) {
            return;
        }
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String customerCode = mdmCustomerImportVo.getCustomerCode();
            if (StringUtils.isEmpty((Object)customerCode) || !dbCustomerCodeSet.contains(customerCode)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u7f16\u7801" + customerCode + "\u5df2\u5b58\u5728;");
        }
    }

    protected void initialsCustomerCode(List<MdmCustomerImportVo> data) {
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmCustomerImportVo.getCustomerCode())) continue;
            mdmCustomerImportVo.setCustomerCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_CUSTOMER.getCode()));
        }
    }
}

