/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.positionlevel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.positionlevel.MdmPositionLevelImportVo;
import com.biz.crm.mdm.positionlevel.entity.MdmPositionLevelEntity;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.mdm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.mdm.role.entity.MdmRoleEntity;
import com.biz.crm.mdm.role.mapper.MdmRoleMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmPositionLevelImportValidator")
public class MdmPositionLevelImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmPositionLevelMapper, MdmPositionLevelEntity, MdmPositionLevelImportVo>
implements ExcelImportValidator<MdmPositionLevelImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionLevelImportValidator.class);
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;
    @Resource
    private MdmRoleMapper mdmRoleMapper;

    @Override
    public void validate(List<MdmPositionLevelImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        HashSet positionLevelCodeUniqueSet = new HashSet(16);
        Set positionCodeSet = data.stream().filter(item -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item.getPositionLevelCode())).map(MdmPositionLevelImportVo::getPositionLevelCode).collect(Collectors.toSet());
        if (!positionCodeSet.isEmpty()) {
            QueryWrapper positionCodeUniqueQuery = new QueryWrapper();
            positionCodeUniqueQuery.in((Object)"position_level_code", positionCodeSet);
            List positionCodeUniqueList = this.mdmPositionLevelMapper.selectList((Wrapper)positionCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionCodeUniqueList)) {
                positionLevelCodeUniqueSet.addAll(positionCodeUniqueList.stream().map(MdmPositionLevelEntity::getPositionLevelCode).collect(Collectors.toSet()));
            }
        }
        HashSet positionLevelNameUniqueSet = new HashSet(16);
        Set positionNameSet = data.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionLevelName())).map(MdmPositionLevelImportVo::getPositionLevelName).collect(Collectors.toSet());
        if (!positionNameSet.isEmpty()) {
            QueryWrapper positionNameUniqueQuery = new QueryWrapper();
            positionNameUniqueQuery.in((Object)"position_level_name", positionNameSet);
            List positionNameUniqueList = this.mdmPositionLevelMapper.selectList((Wrapper)positionNameUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionNameUniqueList)) {
                positionLevelNameUniqueSet.addAll(positionNameUniqueList.stream().map(MdmPositionLevelEntity::getPositionLevelName).collect(Collectors.toSet()));
            }
        }
        HashSet roleCode = new HashSet();
        data.forEach(v -> {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)v.getRoleCode())) {
                List<String> role = Arrays.asList(v.getRoleCode().split(","));
                for (int i = 0; i < role.size(); ++i) {
                    roleCode.add(role.get(i));
                }
            }
        });
        HashSet roleCodeUniqueSet = new HashSet(16);
        if (!roleCode.isEmpty()) {
            QueryWrapper roleCodeUniqueQuery = new QueryWrapper();
            roleCodeUniqueQuery.in((Object)"role_code", roleCode);
            List roleCodeUniqueList = this.mdmRoleMapper.selectList((Wrapper)roleCodeUniqueQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)roleCodeUniqueList)) {
                roleCodeUniqueSet.addAll(roleCodeUniqueList.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.toSet()));
            }
        }
        HashMap positionLevelCodeMap = new HashMap(16);
        HashMap positionLevelNameMap = new HashMap(16);
        data.forEach(v -> {
            StringBuilder msg = new StringBuilder();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)v.getPositionLevelName())) {
                msg.append("\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
            } else if (positionLevelNameMap.containsKey(v.getPositionLevelName())) {
                msg.append("\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u4e0e\u7b2c" + positionLevelNameMap.get(v.getPositionLevelName()) + "\u884c\u91cd\u590d;");
            } else {
                positionLevelNameMap.put(v.getPositionLevelName(), v.getRowIndex());
            }
            if (positionLevelNameUniqueSet.contains(v.getPositionLevelName())) {
                msg.append(v.getPositionLevelName() + "\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u5df2\u5b58\u5728;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)v.getPositionLevelCode())) {
                v.setPositionLevelCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_LEVEL_CODE.getCode()));
            } else {
                if (positionLevelCodeUniqueSet.contains(v.getPositionLevelCode())) {
                    msg.append(v.getPositionLevelCode() + "\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u5df2\u5b58\u5728;");
                }
                if (positionLevelCodeMap.containsKey(v.getPositionLevelCode())) {
                    msg.append("\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0e\u7b2c" + positionLevelCodeMap.get(v.getPositionLevelCode()) + "\u884c\u91cd\u590d;");
                } else {
                    positionLevelCodeMap.put(v.getPositionLevelCode(), v.getRowIndex());
                }
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)v.getRoleCode())) {
                msg.append("\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                HashSet<String> code = new HashSet<String>();
                List<String> list = Arrays.asList(v.getRoleCode().split(","));
                for (int i = 0; i < list.size(); ++i) {
                    if (code.contains(list.get(i))) {
                        msg.append("\u5199\u4e86\u76f8\u540c\u7684\u89d2\u8272\u7f16\u7801");
                    }
                    code.add(list.get(i));
                }
                Iterator r = code.iterator();
                while (r.hasNext()) {
                    if (roleCodeUniqueSet.contains(r.next())) continue;
                    msg.append("\u89d2\u8272\u7f16\u7801\u9519\u8bef;");
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)msg)) {
                v.appendErrorValidateMsg(msg.toString());
            }
        });
    }
}

