/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.product;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.product.MdmProductImportVo;
import com.biz.crm.mdm.material.entity.MdmMaterialEntity;
import com.biz.crm.mdm.material.mapper.MdmMaterialMapper;
import com.biz.crm.mdm.product.entity.MdmProductEntity;
import com.biz.crm.mdm.product.entity.MdmProductLevelEntity;
import com.biz.crm.mdm.product.mapper.MdmProductLevelMapper;
import com.biz.crm.mdm.product.mapper.MdmProductMapper;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmProductImportValidator")
public class MdmProductImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmProductMapper, MdmProductEntity, MdmProductImportVo>
implements ExcelImportValidator<MdmProductImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmProductImportValidator.class);
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    @Resource
    private MdmMaterialMapper mdmMaterialMapper;
    private Pattern pattern = Pattern.compile("[0-9]*");

    @Override
    public void validate(List<MdmProductImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.checkProductNull(data);
        this.initProductCode(data);
        this.checkProductCode(data);
        this.checkProductLevelCode(data);
        this.checkMaterialCode(data);
        this.checkCount(data);
        this.checkIsShelf(data);
        this.checkProductType(data);
        this.checkProductBaseUnit(data);
        this.checkProductSaleUnit(data);
    }

    protected void initProductCode(List<MdmProductImportVo> vos) {
        for (MdmProductImportVo vo : vos) {
            if (!StringUtils.isEmpty((String)vo.getProductCode())) continue;
            vo.setProductCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_PRODUCT_CODE.getCode()));
        }
    }

    protected void checkProductNull(List<MdmProductImportVo> vos) {
        if (CollectionUtil.listNotEmptyNotSizeZero(vos)) {
            vos.stream().forEach(m -> {
                if (StringUtils.isEmpty((String)m.getProductName())) {
                    m.appendErrorValidateMsg("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
                if (StringUtils.isEmpty((String)m.getProductType())) {
                    m.appendErrorValidateMsg("\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
                if (StringUtils.isEmpty((String)m.getIsShelf())) {
                    m.appendErrorValidateMsg("\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
                if (StringUtils.isEmpty((String)m.getBeginDate())) {
                    m.appendErrorValidateMsg("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
                if (StringUtils.isEmpty((String)m.getEndDate())) {
                    m.appendErrorValidateMsg("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
                }
            });
        }
    }

    protected void checkProductCode(List<MdmProductImportVo> vos) {
        List list;
        HashSet<Object> productsSet = new HashSet<Object>();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmProductEntity::getProductCode});
        List mdmProductEntityList = this.mdmProductMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmProductEntityList) && CollectionUtil.listNotEmptyNotSizeZero(list = mdmProductEntityList.stream().filter(m -> StringUtils.isNotEmpty((String)m.getProductCode())).map(m -> m.getProductCode()).collect(Collectors.toList()))) {
            productsSet.addAll(list);
        }
        for (MdmProductImportVo vo : vos) {
            if (productsSet.add(vo.getProductCode())) continue;
            vo.appendErrorValidateMsg(" \u5546\u54c1\u7f16\u7801:" + vo.getProductCode() + "\u91cd\u590d\uff1b");
        }
    }

    protected void checkProductLevelCode(List<MdmProductImportVo> vos) {
        List list;
        HashSet<Object> productsSet = new HashSet<Object>();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode});
        List levelEntities = this.mdmProductLevelMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)levelEntities) && CollectionUtil.listNotEmptyNotSizeZero(list = levelEntities.stream().filter(m -> StringUtils.isNotEmpty((String)m.getProductLevelCode())).map(m -> m.getProductLevelCode()).collect(Collectors.toList()))) {
            productsSet.addAll(list);
        }
        for (MdmProductImportVo vo : vos) {
            String levelCode = vo.getProductLevelCode();
            if (!StringUtils.isNotEmpty((String)levelCode) || !productsSet.add(levelCode)) continue;
            vo.appendErrorValidateMsg(" \u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801:" + levelCode + "\u4e0d\u5b58\u5728\uff1b");
        }
    }

    protected void checkMaterialCode(List<MdmProductImportVo> vos) {
        List material = vos.stream().filter(m -> StringUtils.isNotEmpty((String)m.getMaterialCode())).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(material)) {
            List list;
            HashSet<Object> materialSet = new HashSet<Object>();
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmMaterialEntity::getMaterialCode});
            List mdmMaterialEntities = this.mdmMaterialMapper.selectList((Wrapper)wrapper);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)mdmMaterialEntities) && CollectionUtil.listNotEmptyNotSizeZero(list = mdmMaterialEntities.stream().filter(m -> StringUtils.isNotEmpty((String)m.getMaterialCode())).map(m -> m.getMaterialCode()).collect(Collectors.toList()))) {
                materialSet.addAll(list);
            }
            for (MdmProductImportVo vo : material) {
                if (!materialSet.add(vo.getMaterialCode())) continue;
                vo.appendErrorValidateMsg(" \u7269\u6599\u7f16\u7801:" + vo.getMaterialCode() + "\u4e0d\u5b58\u5728\uff1b");
                break;
            }
        }
    }

    protected void checkCount(List<MdmProductImportVo> vos) {
        if (CollectionUtil.listNotEmptyNotSizeZero(vos)) {
            vos.stream().filter(m -> !Objects.isNull(m.getCount())).forEach(m -> {
                if (!this.pattern.matcher(m.getCount()).matches()) {
                    m.appendErrorValidateMsg(" \u6570\u91cf\uff1a\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\uff1b");
                }
            });
        }
    }

    protected void checkProductType(List<MdmProductImportVo> vos) {
        Map map = DictUtil.dictMap((String)"product_type");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmProductImportVo mdmProductImportVo : vos) {
            String productType = mdmProductImportVo.getProductType();
            if (org.springframework.util.StringUtils.isEmpty((Object)productType)) continue;
            if (!channelMap.containsKey(productType)) {
                mdmProductImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmProductImportVo.getRowIndex() + "\u5546\u54c1\u7c7b\u578b \u5b57\u6bb5product_type:" + productType + "\u4e0d\u5b58\u5728;");
                continue;
            }
            mdmProductImportVo.setProductType((String)channelMap.get(productType));
        }
    }

    protected void checkIsShelf(List<MdmProductImportVo> vos) {
        Map map = DictUtil.dictMap((String)"is_shelf");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmProductImportVo mdmProductImportVo : vos) {
            String isShelf = mdmProductImportVo.getIsShelf();
            if (org.springframework.util.StringUtils.isEmpty((Object)isShelf)) continue;
            if (!channelMap.containsKey(isShelf)) {
                mdmProductImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmProductImportVo.getRowIndex() + "\u4e0a\u4e0b\u67b6\u72b6\u6001\u5b57\u6bb5is_shelf:" + isShelf + "\u4e0d\u5b58\u5728;");
                continue;
            }
            mdmProductImportVo.setIsShelf((String)channelMap.get(isShelf));
        }
    }

    protected void checkProductBaseUnit(List<MdmProductImportVo> vos) {
        Map map = DictUtil.dictMap((String)"product_base_unit");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmProductImportVo mdmProductImportVo : vos) {
            String baseUnit = mdmProductImportVo.getBaseUnit();
            if (org.springframework.util.StringUtils.isEmpty((Object)baseUnit)) continue;
            if (!channelMap.containsKey(baseUnit)) {
                mdmProductImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmProductImportVo.getRowIndex() + "\u5546\u54c1\u57fa\u672c\u5355\u4f4d\u5b57\u5178material_base_unit:" + baseUnit + "\u4e0d\u5b58\u5728;");
                continue;
            }
            mdmProductImportVo.setBaseUnit((String)channelMap.get(baseUnit));
        }
    }

    protected void checkProductSaleUnit(List<MdmProductImportVo> vos) {
        Map map = DictUtil.dictMap((String)"product_sale_unit");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmProductImportVo mdmProductImportVo : vos) {
            String saleUnit = mdmProductImportVo.getSaleUnit();
            if (org.springframework.util.StringUtils.isEmpty((Object)saleUnit)) continue;
            if (!channelMap.containsKey(saleUnit)) {
                mdmProductImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmProductImportVo.getRowIndex() + "\u5546\u54c1\u9500\u552e\u5355\u4f4d\u5b57\u5178material_sale_unit:" + saleUnit + "\u4e0d\u5b58\u5728;");
                continue;
            }
            mdmProductImportVo.setSaleUnit((String)channelMap.get(saleUnit));
        }
    }
}

