/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.user;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.user.MdmUserImportVo;
import com.biz.crm.mdm.position.entity.MdmPositionEntity;
import com.biz.crm.mdm.position.entity.MdmPositionUserEntity;
import com.biz.crm.mdm.position.mapper.MdmPositionMapper;
import com.biz.crm.mdm.position.mapper.MdmPositionUserMapper;
import com.biz.crm.mdm.user.entity.MdmUserEntity;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="mdmUserImportValidator")
public class MdmUserImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmUserMapper, MdmUserEntity, MdmUserImportVo>
implements ExcelImportValidator<MdmUserImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmUserImportValidator.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmPositionUserMapper mdmPositionUserMapper;
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    private final String PHONE_REGEX = "[1][\\d]{10}";

    @Override
    public void validate(List<MdmUserImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.verify(data);
    }

    protected void verify(List<MdmUserImportVo> originList) {
        Map<Object, Object> userNameCheckMap = new HashMap(16);
        Set paramUserNameSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getUserName())).map(MdmUserImportVo::getUserName).collect(Collectors.toSet());
        if (!paramUserNameSet.isEmpty()) {
            QueryWrapper userNameQuery = new QueryWrapper();
            userNameQuery.in((Object)"user_name", paramUserNameSet);
            List userNameQueryEntityList = this.mdmUserMapper.selectList((Wrapper)userNameQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)userNameQueryEntityList)) {
                userNameCheckMap = userNameQueryEntityList.stream().collect(Collectors.toMap(MdmUserEntity::getUserName, MdmUserEntity::getUserType));
            }
        }
        HashMap genderValueCodeMap = new HashMap(16);
        for (Map.Entry entry : DictUtil.dictMap((String)"gender").entrySet()) {
            if (genderValueCodeMap.containsKey(entry.getValue())) continue;
            genderValueCodeMap.put(entry.getValue(), entry.getKey());
        }
        HashMap<String, MdmPositionEntity> positionMap = new HashMap<String, MdmPositionEntity>(16);
        HashMap<String, MdmPositionUserEntity> hashMap = new HashMap<String, MdmPositionUserEntity>(16);
        Set paramPositionCodeSet = originList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPrimaryPositionCode())).map(MdmUserImportVo::getPrimaryPositionCode).collect(Collectors.toSet());
        for (MdmUserImportVo item2 : originList) {
            if (!StringUtils.isNotEmpty((String)item2.getOtherPositionCodes())) continue;
            paramPositionCodeSet.addAll(Arrays.asList(item2.getOtherPositionCodes().split(",")));
        }
        if (!paramPositionCodeSet.isEmpty()) {
            QueryWrapper primaryPositionQuery = new QueryWrapper();
            primaryPositionQuery.in((Object)"position_code", paramPositionCodeSet);
            List primaryPositionEntityList = this.mdmPositionMapper.selectList((Wrapper)primaryPositionQuery);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)primaryPositionEntityList)) {
                positionMap.putAll(primaryPositionEntityList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v)));
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"position_code", paramPositionCodeSet);
                hashMap.putAll(this.mdmPositionUserMapper.selectList((Wrapper)queryWrapper).stream().collect(Collectors.toMap(MdmPositionUserEntity::getPositionCode, v -> v)));
            }
        }
        HashMap<String, Integer> userNameIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> primaryPositionIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> otherPositionIndexMap = new HashMap<String, Integer>(16);
        for (MdmUserImportVo item3 : originList) {
            if (StringUtils.isEmpty((String)item3.getUserName())) {
                item3.appendErrorValidateMsg("\u7f3a\u5931\u8d26\u53f7\uff1b");
            } else {
                if (userNameIndexMap.containsKey(item3.getUserName())) {
                    item3.appendErrorValidateMsg("\u8d26\u53f7\u4e0e\u7b2c" + userNameIndexMap.get(item3.getUserName()) + "\u884c\u91cd\u590d\uff1b");
                } else {
                    userNameIndexMap.put(item3.getUserName(), item3.getRowIndex());
                }
                if (userNameCheckMap.containsKey(item3.getUserName())) {
                    item3.appendErrorValidateMsg("\u8d26\u53f7\u5df2\u5b58\u5728\uff1b");
                }
            }
            if (StringUtils.isEmpty((String)item3.getFullName())) {
                item3.appendErrorValidateMsg("\u7f3a\u5931\u7528\u6237\u540d\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item3.getGenderName())) {
                if (!genderValueCodeMap.containsKey(item3.getGenderName())) {
                    item3.appendErrorValidateMsg("\u6027\u522b\u65e0\u6548\uff1b");
                } else {
                    item3.setGender((String)genderValueCodeMap.get(item3.getGenderName()));
                }
            }
            if (StringUtils.isEmpty((String)item3.getUserPassword())) {
                item3.appendErrorValidateMsg("\u7f3a\u5931\u5bc6\u7801\uff1b");
            }
            if (StringUtils.isEmpty((String)item3.getUserPhone())) {
                item3.appendErrorValidateMsg("\u7f3a\u5931\u8054\u7cfb\u7535\u8bdd\uff1b");
            } else if (!item3.getUserPhone().matches("[1][\\d]{10}")) {
                item3.appendErrorValidateMsg("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            }
            if (StringUtils.isNotEmpty((String)item3.getEmail()) && item3.getEmail().length() - item3.getEmail().replace("@", "").length() != 1) {
                item3.appendErrorValidateMsg("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            }
            if (StringUtils.isEmpty((String)item3.getStartTime())) {
                item3.appendErrorValidateMsg("\u7f3a\u5931\u751f\u6548\u65f6\u95f4\uff1b");
            } else if (!this.verifyDateFormat(item3.getStartTime(), "yyyy-MM-dd")) {
                item3.appendErrorValidateMsg("\u751f\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b");
            } else {
                item3.setStartTime(item3.getStartTime() + " 00:00:00");
            }
            if (StringUtils.isEmpty((String)item3.getEndTime())) {
                item3.appendErrorValidateMsg("\u7f3a\u5931\u5931\u6548\u65f6\u95f4\uff1b");
            } else if (!this.verifyDateFormat(item3.getEndTime(), "yyyy-MM-dd")) {
                item3.appendErrorValidateMsg("\u5931\u6548\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b");
            } else {
                item3.setEndTime(item3.getEndTime() + " 23:59:59");
            }
            if (StringUtils.isEmpty((String)item3.getPrimaryPositionCode())) {
                item3.appendErrorValidateMsg("\u7f3a\u5931\u4e3b\u804c\u4f4d\u7f16\u7801\uff1b");
            } else {
                if (!positionMap.containsKey(item3.getPrimaryPositionCode())) {
                    item3.appendErrorValidateMsg("\u4e3b\u804c\u4f4d\u7f16\u7801\u65e0\u6548\uff1b");
                } else if (hashMap.containsKey(item3.getPrimaryPositionCode()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(((MdmPositionUserEntity)((Object)hashMap.get(item3.getPrimaryPositionCode()))).getPrimaryFlag())) {
                    item3.appendErrorValidateMsg("\u4e3b\u804c\u4f4d\u5df2\u7ecf\u662f\u5176\u5b83\u7528\u6237\u7684\u4e3b\u804c\u4f4d\uff1b");
                }
                if (primaryPositionIndexMap.containsKey(item3.getPrimaryPositionCode())) {
                    item3.appendErrorValidateMsg("\u4e3b\u804c\u4f4d\u4e0e\u7b2c" + primaryPositionIndexMap.get(item3.getPrimaryPositionCode()) + "\u884c\u4e3b\u804c\u4f4d\u91cd\u590d\uff1b");
                } else {
                    primaryPositionIndexMap.put(item3.getPrimaryPositionCode(), item3.getRowIndex());
                }
                if (otherPositionIndexMap.containsKey(item3.getPrimaryPositionCode())) {
                    item3.appendErrorValidateMsg("\u4e3b\u804c\u4f4d\u5728\u7b2c" + otherPositionIndexMap.get(item3.getPrimaryPositionCode()) + "\u884c\u5df2\u5b58\u5728\uff1b");
                }
            }
            if (StringUtils.isNotEmpty((String)item3.getOtherPositionCodes())) {
                for (String positionCode : item3.getOtherPositionCodes().split(",")) {
                    if (!positionMap.containsKey(positionCode)) {
                        item3.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801[" + positionCode + "]\u65e0\u6548\uff1b");
                    } else if (hashMap.containsKey(item3.getPrimaryPositionCode()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(((MdmPositionUserEntity)((Object)hashMap.get(item3.getPrimaryPositionCode()))).getPrimaryFlag())) {
                        item3.appendErrorValidateMsg("\u804c\u4f4d[" + positionCode + "]\u5df2\u7ecf\u662f\u5176\u5b83\u7528\u6237\u7684\u4e3b\u804c\u4f4d\uff1b");
                    }
                    if (primaryPositionIndexMap.containsKey(positionCode)) {
                        item3.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801[" + positionCode + "]\u4e0e\u7b2c" + primaryPositionIndexMap.get(positionCode) + "\u884c\u4e3b\u804c\u4f4d\u91cd\u590d\uff1b");
                    }
                    if (otherPositionIndexMap.containsKey(positionCode)) {
                        item3.appendErrorValidateMsg("\u804c\u4f4d\u7f16\u7801[" + positionCode + "]\u5728\u7b2c" + otherPositionIndexMap.get(positionCode) + "\u884c\u5df2\u5b58\u5728\uff1b");
                        continue;
                    }
                    otherPositionIndexMap.put(positionCode, item3.getRowIndex());
                }
            }
            if (AbstractImportVo.ProcessTypeEnum.SUCCESS != item3.getProcessType()) continue;
            ArrayList<String> codeList = new ArrayList<String>();
            ArrayList<String> nameList = new ArrayList<String>();
            codeList.add(item3.getPrimaryPositionCode());
            nameList.add(((MdmPositionEntity)((Object)positionMap.get(item3.getPrimaryPositionCode()))).getPositionName());
            if (StringUtils.isNotEmpty((String)item3.getOtherPositionCodes())) {
                for (String positionCode : item3.getOtherPositionCodes().split(",")) {
                    codeList.add(positionCode);
                    nameList.add(((MdmPositionEntity)((Object)positionMap.get(positionCode))).getPositionName());
                }
            }
            item3.setPositionCodeRedundancy(String.join((CharSequence)",", codeList));
            item3.setPositionNameRedundancy(String.join((CharSequence)",", nameList));
        }
    }

    private boolean verifyDateFormat(String dataStr, String formatStr) {
        boolean flag = false;
        if (StringUtils.isNotEmpty((String)dataStr) && StringUtils.isNotEmpty((String)formatStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                Date parse = sdf.parse(dataStr);
                String dateFormatStr = sdf.format(parse);
                if (dataStr.equals(dateFormatStr)) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }
}

