/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.consumer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.excel.service.IExcelService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.Result;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="WEBSOCKET_SESSION", consumerGroup="WEBSOCKET_SESSION${rocketmq.environment-variable}", consumeMode=ConsumeMode.ORDERLY)
public class ExcelExportConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportConsumer.class);
    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();
    @Autowired
    private IExcelService excelExportService;

    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String result = message.getMsgBody();
        log.warn("\u63a5\u6536\u6d88\u606f:{}", (Object)result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String clientId = jsonObject.get((Object)"sid").toString();
        String websocketMessage = jsonObject.get((Object)"websocketMessage").toString();
        Boolean flag = userWebSocketHandler.getWebSocketSession(clientId);
        if (flag.booleanValue()) {
            userWebSocketHandler.sendMessageToUser(clientId, new TextMessage((CharSequence)JSONObject.toJSONString((Object)Result.ok((String)websocketMessage))));
        }
        return jsonObject;
    }
}

