/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.util.MqMessageParam;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.util.JsonPropertyUtil;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImportHelper<M extends BaseMapper<T>, T>
extends ServiceImpl<M, T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractImportHelper.class);
    @Resource
    private RocketMQProducer rocketMQProducer;

    protected void sendWebsocketMsgMQ(String msg, DefaultImportContext context) {
        String webSocketClientId = context.getImportParamVo().getWebSocketClientId();
        if (StringUtils.isBlank((CharSequence)webSocketClientId)) {
            if (log.isInfoEnabled()) {
                log.info("\u672a\u63d0\u4ea4 websocket id\uff0c\u5ffd\u7565 websocket \u6d88\u606f\u53d1\u9001\uff01");
            }
            return;
        }
        MqMessageParam mqMessageParam = new MqMessageParam();
        mqMessageParam.setClientId(webSocketClientId);
        mqMessageParam.setMsg(msg);
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        mqMessageBody.setTag("EXCEL_IMPORT_WEBSOCKET_MSG");
        mqMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)mqMessageParam));
        this.rocketMQProducer.convertAndSend(mqMessageBody);
    }
}

