/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.excel.component.validator.mdm.customer;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.biz.crm.excel.component.validator.AbstractExcelImportValidator;
import com.biz.crm.excel.component.validator.ExcelImportValidator;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.mdm.customer.MdmCustomerImportVo;
import com.biz.crm.mdm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.mdm.customer.model.MdmCustomerEntity;
import com.biz.crm.mdm.customerorg.entity.MdmCusOrgEntity;
import com.biz.crm.mdm.customerorg.mapper.MdmCusOrgMapper;
import com.biz.crm.mdm.org.entity.MdmOrgEntity;
import com.biz.crm.mdm.org.mapper.MdmOrgMapper;
import com.biz.crm.mdm.user.mapper.MdmUserMapper;
import com.biz.crm.util.DictUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="mdmCustomerImportValidator")
public class MdmCustomerImportValidator<M extends BaseMapper<T>, T>
extends AbstractExcelImportValidator<MdmCustomerMsgMapper, MdmCustomerEntity, MdmCustomerImportVo>
implements ExcelImportValidator<MdmCustomerImportVo> {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerImportValidator.class);
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;
    @Resource
    private MdmUserMapper mdmUserMapper;
    private final String NUM_REGEX = "^[0-9]*$";

    @Override
    public void validate(List<MdmCustomerImportVo> data, DefaultImportContext context) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.validCustomerCode(data);
        this.validCustomerName(data);
        this.validChannel(data);
        this.validCustomerType(data);
        this.validOrgCode(data);
        this.validCustomerOrgCode(data);
        this.validCustomerPhone(data);
    }

    protected void validCustomerOrgCode(List<MdmCustomerImportVo> data) {
        long count = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getCustomerOrgCode())).count();
        if (count < 1L) {
            return;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmCusOrgEntity::getCustomerOrgCode});
        Set dbCustomerOrgSet = this.mdmCusOrgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getCustomerOrgCode())).map(MdmCusOrgEntity::getCustomerOrgCode).collect(Collectors.toSet());
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String customerOrgCode = mdmCustomerImportVo.getCustomerOrgCode();
            if (StringUtils.isEmpty((Object)customerOrgCode) || !CollectionUtils.isEmpty(dbCustomerOrgSet) && dbCustomerOrgSet.contains(customerOrgCode)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801" + customerOrgCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCustomerPhone(List<MdmCustomerImportVo> data) {
        for (MdmCustomerImportVo item : data) {
            if (!StringUtils.isEmpty((Object)item.getCustomerContact()) && !item.getCustomerContact().matches("^[0-9]*$")) {
                item.appendErrorValidateMsg("\u5ba2\u6237\u8054\u7cfb\u65b9\u5f0f\u4ec5\u80fd\u8f93\u5165\u6570\u5b57;");
            }
            if (StringUtils.isEmpty((Object)item.getContactPhone()) || item.getContactPhone().matches("^[0-9]*$")) continue;
            item.appendErrorValidateMsg("\u8054\u7cfb\u4eba\u7535\u8bdd\u4ec5\u80fd\u8f93\u5165\u6570\u5b57;");
        }
    }

    protected void validOrgCode(List<MdmCustomerImportVo> data) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery().select(new SFunction[]{MdmOrgEntity::getOrgCode});
        Set dbOrgCodeSet = this.mdmOrgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getOrgCode())).map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet());
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String orgCode = mdmCustomerImportVo.getOrgCode();
            if (StringUtils.isEmpty((Object)orgCode)) {
                mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u7ec4\u7ec7\u7f16\u7801\u672a\u586b\u5199;");
                continue;
            }
            if (orgCode.contains(",")) {
                String[] orgCodeList;
                for (String splitOrgCode : orgCodeList = orgCode.split(",")) {
                    if (!CollectionUtils.isEmpty(dbOrgCodeSet) && dbOrgCodeSet.contains(splitOrgCode)) continue;
                    mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u7ec4\u7ec7\u7f16\u7801" + splitOrgCode + "\u4e0d\u5b58\u5728;");
                }
                continue;
            }
            if (!CollectionUtils.isEmpty(dbOrgCodeSet) && dbOrgCodeSet.contains(orgCode)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u7ec4\u7ec7\u7f16\u7801" + orgCode + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCustomerType(List<MdmCustomerImportVo> data) {
        Map customerTypeMap = DictUtil.dictMap((String)"customer_type");
        HashMap customerTypeNameCodeMap = new HashMap();
        for (Map.Entry entry : customerTypeMap.entrySet()) {
            customerTypeNameCodeMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String customerTypeName = mdmCustomerImportVo.getCustomerTypeName();
            if (StringUtils.isEmpty((Object)customerTypeName)) {
                mdmCustomerImportVo.appendErrorValidateMsg("\u5ba2\u6237\u7c7b\u578b\u672a\u586b\u5199;");
                continue;
            }
            if (!customerTypeNameCodeMap.containsKey(customerTypeName)) {
                mdmCustomerImportVo.appendErrorValidateMsg("\u5ba2\u6237\u7c7b\u578b\u3010" + customerTypeName + "\u3011\u4e0d\u5b58\u5728;");
                continue;
            }
            mdmCustomerImportVo.setCustomerType((String)customerTypeNameCodeMap.get(customerTypeName));
        }
    }

    protected void validChannel(List<MdmCustomerImportVo> data) {
        Map map = DictUtil.dictMap((String)"channel");
        HashMap channelMap = new HashMap(16);
        for (Map.Entry entry : map.entrySet()) {
            if (channelMap.containsKey(entry.getValue())) continue;
            channelMap.put(entry.getValue(), entry.getKey());
        }
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            String channel = mdmCustomerImportVo.getChannel();
            if (StringUtils.isEmpty((Object)channel)) {
                mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u6e20\u9053\u672a\u586b\u5199;");
                continue;
            }
            if (channelMap != null && channelMap.containsKey(channel)) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u6e20\u9053" + channel + "\u4e0d\u5b58\u5728;");
        }
    }

    protected void validCustomerName(List<MdmCustomerImportVo> data) {
        for (MdmCustomerImportVo mdmCustomerImportVo : data) {
            if (!StringUtils.isEmpty((Object)mdmCustomerImportVo.getCustomerName())) continue;
            mdmCustomerImportVo.appendErrorValidateMsg("\u884c\u53f7:" + mdmCustomerImportVo.getRowIndex() + ",\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
    }

    protected void validCustomerCode(List<MdmCustomerImportVo> data) {
        MdmCustomerImportVo item;
        String customerCode;
        Set collect = data.stream().filter(x -> !StringUtils.isEmpty((Object)x.getCustomerCode())).map(MdmCustomerImportVo::getCustomerCode).collect(Collectors.toSet());
        if (collect.isEmpty()) {
            return;
        }
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)Wrappers.lambdaQuery().in(MdmCustomerEntity::getCustomerCode, collect)).select(new SFunction[]{MdmCustomerEntity::getCustomerCode});
        Set dbCustomerCodeSet = this.mdmCustomerMsgMapper.selectList((Wrapper)wrapper).stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getCustomerCode())).map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toSet());
        HashMap<String, Integer> codeIndexMap = new HashMap<String, Integer>(16);
        Iterator<MdmCustomerImportVo> iterator = data.iterator();
        while (iterator.hasNext() && !StringUtils.isEmpty((Object)(customerCode = (item = iterator.next()).getCustomerCode()))) {
            if (dbCustomerCodeSet.contains(customerCode)) {
                item.appendErrorValidateMsg("\u5ba2\u6237\u7f16\u7801\u3010" + customerCode + "\u3011\u5df2\u5b58\u5728;");
                continue;
            }
            if (codeIndexMap.containsKey(customerCode)) {
                item.appendErrorValidateMsg("\u5ba2\u6237\u7f16\u7801\u3010" + customerCode + "\u3011\u4e0e\u7b2c" + codeIndexMap.get(customerCode) + "\u884c\u91cd\u590d;");
                continue;
            }
            codeIndexMap.put(customerCode, item.getRowIndex());
        }
    }
}

